/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.stacktrace;

import com.google.common.base.Optional;

public class At {
    private final String _classname;
    private final String _method;
    private final String _file;
    private final Integer _line;

    public At(String classname, String method, String file, String line) {
        this._classname = classname;
        this._method = method;
        this._file = file;
        this._line = line != null ? Integer.valueOf(line) : null;
    }

    public String classname() {
        return this._classname;
    }

    public String method() {
        return this._method;
    }

    public Optional<String> file() {
        return Optional.fromNullable((Object)this._file);
    }

    public Optional<Integer> line() {
        return Optional.fromNullable((Object)this._line);
    }

    public String toString() {
        return "\tat " + this._classname + "." + this._method + "(" + (this._file != null && this._line != null ? "" + this._file + ":" + this._line : "???") + ")";
    }
}

