/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.stacktrace;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.flapdoodle.logparser.stacktrace.At;
import de.flapdoodle.logparser.stacktrace.CauseBy;
import de.flapdoodle.logparser.stacktrace.ExceptionAndMessage;
import de.flapdoodle.logparser.stacktrace.StackLines;
import java.util.List;

public abstract class AbstractStackFrame {
    protected final ExceptionAndMessage _exceptionAndMessage;
    protected final ImmutableList<StackLines> _stackLines;
    protected final CauseBy _cause;

    protected AbstractStackFrame(ExceptionAndMessage exceptionAndMessage, List<StackLines> stackLines, CauseBy cause) {
        if (stackLines.isEmpty()) {
            throw new RuntimeException("stacklines emtpy");
        }
        this._exceptionAndMessage = exceptionAndMessage;
        this._cause = cause;
        this._stackLines = ImmutableList.copyOf(stackLines);
    }

    public ExceptionAndMessage exception() {
        return this._exceptionAndMessage;
    }

    public Optional<CauseBy> cause() {
        return Optional.fromNullable((Object)this._cause);
    }

    public AbstractStackFrame rootCause() {
        if (this._cause != null) {
            return this._cause.rootCause();
        }
        return this;
    }

    public ImmutableList<StackLines> stackLines() {
        return this._stackLines;
    }

    public Optional<At> firstAt() {
        return this.firstStackLines().firstAt();
    }

    public StackLines firstStackLines() {
        return (StackLines)this._stackLines.get(0);
    }
}

