/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.regex;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Patterns {
    static final Logger _logger = Logger.getLogger(Pattern.class.getName());
    static final IPatternNameSetExtractor PATTERN_NAME_SET_EXTRACTOR;

    private Patterns() {
    }

    public static Set<String> names(Pattern pattern) {
        return PATTERN_NAME_SET_EXTRACTOR.names(pattern);
    }

    public static boolean find(Pattern pattern, CharSequence input) {
        return pattern.matcher(input).find();
    }

    public static Optional<Map<String, String>> match(Matcher matcher) {
        Set<String> names = Patterns.names(matcher.pattern());
        return Patterns.match(matcher, names);
    }

    public static Optional<Map<String, String>> match(Matcher matcher, Set<String> names) {
        if (matcher.find()) {
            HashMap map = Maps.newHashMap();
            for (String name : names) {
                String value = matcher.group(name);
                if (value == null) continue;
                map.put(name, value);
            }
            return Optional.of((Object)map);
        }
        return Optional.absent();
    }

    public static Pattern build(Collection<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return Pattern.compile(sb.toString());
    }

    public static Pattern build(String ... parts) {
        return Patterns.build(Patterns.asCollection(parts));
    }

    public static Pattern join(Pattern ... patterns) {
        return Patterns.join(Patterns.asCollection(patterns));
    }

    public static Pattern join(Collection<Pattern> patterns) {
        return Patterns.build(Patterns.asStrings(patterns));
    }

    public static Pattern group(Pattern ... patterns) {
        return Patterns.build(Patterns.join("(", Patterns.asStrings(Patterns.asCollection(patterns)), ")"));
    }

    public static Pattern group(String ... patterns) {
        return Patterns.build(Patterns.join("(", Patterns.asCollection(patterns), ")"));
    }

    public static Pattern namedGroup(String name, String ... patterns) {
        return Patterns.build(Patterns.join(Patterns.asCollection("(?<", name, ">"), Patterns.asCollection(patterns), Patterns.asCollection(")")));
    }

    public static Pattern namedGroup(String name, Pattern ... patterns) {
        return Patterns.build(Patterns.join(Patterns.asCollection("(?<", name, ">"), Patterns.asStrings(Patterns.asCollection(patterns)), Patterns.asCollection(")")));
    }

    private static Collection<String> asStrings(Collection<Pattern> patterns) {
        return Collections2.transform(patterns, (Function)new Function<Pattern, String>(){

            public String apply(Pattern input) {
                return input.pattern();
            }
        });
    }

    private static <T> Collection<T> join(T before, Collection<T> collections, T ... after) {
        ArrayList ret = Lists.newArrayList();
        ret.add(before);
        ret.addAll(collections);
        for (T a : after) {
            ret.add(a);
        }
        return ret;
    }

    private static <T> Collection<T> join(Collection<T> ... collections) {
        ArrayList ret = Lists.newArrayList();
        for (Collection<T> collection : collections) {
            ret.addAll(collection);
        }
        return ret;
    }

    private static <T> Collection<T> asCollection(T ... values) {
        return Lists.newArrayList((Object[])values);
    }

    static {
        IPatternNameSetExtractor instance = new ParsePatternForGroupNamesNameSetExtractor();
        try {
            instance = new ProtectedMethodCallSetExtractor();
        }
        catch (RuntimeException ex) {
            _logger.log(Level.WARNING, "choose pattern name set extractor", ex);
        }
        PATTERN_NAME_SET_EXTRACTOR = instance;
    }

    @VisibleForTesting
    protected static class ProtectedMethodCallSetExtractor
    implements IPatternNameSetExtractor {
        final Method PATTERN_NAMED_GROUP_METHOD;

        protected ProtectedMethodCallSetExtractor() {
            try {
                this.PATTERN_NAMED_GROUP_METHOD = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
                this.PATTERN_NAMED_GROUP_METHOD.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<String, Integer> callProtectedNamedGroupsMethod(Pattern pattern) {
            try {
                return (Map)this.PATTERN_NAMED_GROUP_METHOD.invoke((Object)pattern, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Set<String> names(Pattern pattern) {
            return ImmutableSet.copyOf(this.callProtectedNamedGroupsMethod(pattern).keySet());
        }
    }

    @VisibleForTesting
    protected static class ParsePatternForGroupNamesNameSetExtractor
    implements IPatternNameSetExtractor {
        final Pattern GROUP_NAMES_PATTERN = Pattern.compile("\\?\\<([a-zA-Z0-9]+)\\>");

        protected ParsePatternForGroupNamesNameSetExtractor() {
        }

        protected Set<String> namesFallback(Pattern pattern) {
            HashSet ret = Sets.newHashSet();
            Matcher groupNamesMatcher = this.GROUP_NAMES_PATTERN.matcher(pattern.pattern());
            while (groupNamesMatcher.find()) {
                ret.add(groupNamesMatcher.group(1));
            }
            return ret;
        }

        @Override
        public Set<String> names(Pattern pattern) {
            return ImmutableSet.copyOf(this.namesFallback(pattern));
        }
    }

    @VisibleForTesting
    protected static interface IPatternNameSetExtractor {
        public Set<String> names(Pattern var1);
    }
}

