/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher.stacktrace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.flapdoodle.logparser.IBackBuffer;
import de.flapdoodle.logparser.IMatch;
import de.flapdoodle.logparser.IMatcher;
import de.flapdoodle.logparser.IReader;
import de.flapdoodle.logparser.matcher.stacktrace.At;
import de.flapdoodle.logparser.matcher.stacktrace.CauseBy;
import de.flapdoodle.logparser.matcher.stacktrace.FirstLine;
import de.flapdoodle.logparser.matcher.stacktrace.More;
import de.flapdoodle.logparser.stacktrace.ExceptionAndMessage;
import de.flapdoodle.logparser.stacktrace.StackTrace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StackTraceMatcher
implements IMatcher<StackTrace> {
    static final int MAX_LOOK_AHEAD = 30;

    @Override
    public Optional<IMatch<StackTrace>> match(IReader reader, IBackBuffer backBuffer) throws IOException {
        Optional<String> possibleFirstLine = reader.nextLine();
        if (possibleFirstLine.isPresent()) {
            String firstLineAsString = (String)possibleFirstLine.get();
            if (CauseBy.find(firstLineAsString)) {
                return Optional.absent();
            }
            if (At.find(firstLineAsString)) {
                return Optional.absent();
            }
            if (More.find(firstLineAsString)) {
                return Optional.absent();
            }
            if (this.causeByIn(backBuffer.lastLines())) {
                return Optional.absent();
            }
            Optional<FirstLine> firstLine = FirstLine.match(firstLineAsString);
            if (firstLine.isPresent()) {
                int leftToTry = 30;
                ArrayList messageLines = Lists.newArrayList();
                do {
                    --leftToTry;
                    Optional<String> possibleSecondLine = reader.nextLine();
                    if (possibleSecondLine.isPresent()) {
                        Optional<At> secondLine = At.match((CharSequence)possibleSecondLine.get());
                        if (secondLine.isPresent()) {
                            return Optional.of((Object)new StackTraceMatch((FirstLine)firstLine.get(), messageLines, (At)secondLine.get()));
                        }
                        messageLines.add(possibleSecondLine.get());
                        continue;
                    }
                    leftToTry = 0;
                } while (leftToTry > 0);
            }
        }
        return Optional.absent();
    }

    private boolean causeByIn(ImmutableList<String> lastLines) {
        for (String line : lastLines) {
            if (!CauseBy.find(line)) continue;
            return true;
        }
        return false;
    }

    private static StackTrace toStackTrace(List<String> source, Stack stack) {
        return new StackTrace(source, StackTraceMatcher.exceptionAndMessage(stack._firstLine, stack.messages()), StackTraceMatcher.stackLines(stack.stackLines()), StackTraceMatcher.cause(stack.causeBy()));
    }

    private static de.flapdoodle.logparser.stacktrace.CauseBy cause(CauseByStack causeBy) {
        if (causeBy != null) {
            return new de.flapdoodle.logparser.stacktrace.CauseBy(StackTraceMatcher.exceptionAndMessage(causeBy._cause, causeBy.messages()), StackTraceMatcher.stackLines(causeBy.stackLines()), StackTraceMatcher.cause(causeBy.causeBy()));
        }
        return null;
    }

    private static de.flapdoodle.logparser.stacktrace.More more(More more) {
        if (more != null) {
            return new de.flapdoodle.logparser.stacktrace.More(more.count());
        }
        return null;
    }

    private static List<de.flapdoodle.logparser.stacktrace.StackLines> stackLines(List<StackLines> atLines) {
        return Lists.transform(atLines, (Function)new Function<StackLines, de.flapdoodle.logparser.stacktrace.StackLines>(){

            public de.flapdoodle.logparser.stacktrace.StackLines apply(StackLines at) {
                return new de.flapdoodle.logparser.stacktrace.StackLines(StackTraceMatcher.at(at.atLines()), StackTraceMatcher.more(at.more()));
            }
        });
    }

    private static List<de.flapdoodle.logparser.stacktrace.At> at(List<At> atLines) {
        return Lists.transform(atLines, (Function)new Function<At, de.flapdoodle.logparser.stacktrace.At>(){

            public de.flapdoodle.logparser.stacktrace.At apply(At at) {
                return new de.flapdoodle.logparser.stacktrace.At(at.classname(), at.method(), at.file(), at.lineNr());
            }
        });
    }

    private static ExceptionAndMessage exceptionAndMessage(CauseBy causeBy, List<String> messages) {
        return new ExceptionAndMessage(causeBy.exception(), (List<String>)ImmutableList.builder().add((Object)causeBy.message()).addAll(messages).build());
    }

    private static ExceptionAndMessage exceptionAndMessage(FirstLine firstLine, List<String> messages) {
        return new ExceptionAndMessage(firstLine.exception(), (List<String>)ImmutableList.builder().add((Object)firstLine.message()).addAll(messages).build());
    }

    static class CauseByStack
    extends AbstractStack {
        private final CauseBy _cause;

        public CauseByStack(CauseBy cause) {
            this._cause = cause;
        }
    }

    static class Stack
    extends AbstractStack {
        private final FirstLine _firstLine;

        Stack(FirstLine firstLine, List<String> messages, At at) {
            this._firstLine = firstLine;
            this.addMessages(messages);
            this.currentStackLines().add(at);
        }
    }

    static class StackLines
    implements IStackLines {
        private final List<At> _atLines = Lists.newArrayList();
        private More _more;

        StackLines() {
        }

        @Override
        public void add(At at) {
            if (this._more != null) {
                throw new RuntimeException("more (" + this._more.line() + ") allready set for this stackframe, at=" + at.line());
            }
            this._atLines.add(at);
        }

        public List<At> atLines() {
            return ImmutableList.copyOf(this._atLines);
        }

        @Override
        public void more(More more) {
            this._more = more;
        }

        public More more() {
            return this._more;
        }
    }

    static abstract class AbstractStack
    implements IStackContainer {
        private final List<StackLines> _stackLines = Lists.newArrayList((Object[])new StackLines[]{new StackLines()});
        private CauseByStack _causeBy;
        private final List<String> _messages = Lists.newArrayList();

        AbstractStack() {
        }

        @Override
        public IStackContainer causeBy(CauseBy causeBy) {
            this._causeBy = new CauseByStack(causeBy);
            return this._causeBy;
        }

        @Override
        public IStackLines currentStackLines() {
            return this._stackLines.get(this._stackLines.size() - 1);
        }

        @Override
        public IStackLines newStackLines() {
            StackLines ret = new StackLines();
            this._stackLines.add(ret);
            return ret;
        }

        public ImmutableList<StackLines> stackLines() {
            return ImmutableList.copyOf(this._stackLines);
        }

        public CauseByStack causeBy() {
            return this._causeBy;
        }

        @Override
        public void addMessage(String line) {
            this._messages.add(line);
        }

        public void addMessages(List<String> messages) {
            this._messages.addAll(messages);
        }

        public ImmutableList<String> messages() {
            return ImmutableList.copyOf(this._messages);
        }
    }

    static interface IStackContainer {
        public IStackLines newStackLines();

        public IStackContainer causeBy(CauseBy var1);

        public IStackLines currentStackLines();

        public void addMessage(String var1);
    }

    static interface IStackLines {
        public void add(At var1);

        public void more(More var1);
    }

    static class StackTraceMatch
    implements IMatch<StackTrace> {
        private Stack _stack;

        public StackTraceMatch(FirstLine firstLine, List<String> messages, At at) {
            this._stack = new Stack(firstLine, messages, at);
        }

        @Override
        public StackTrace process(List<String> lines) throws IOException {
            IStackContainer stack = this._stack;
            IStackLines stackLines = stack.currentStackLines();
            boolean lastOneWasCauseBy = false;
            for (String line : lines) {
                Optional<At> at = At.match(line);
                if (at.isPresent()) {
                    lastOneWasCauseBy = false;
                    stackLines.add((At)at.get());
                    continue;
                }
                Optional<CauseBy> causeBy = CauseBy.match(line);
                if (causeBy.isPresent()) {
                    lastOneWasCauseBy = true;
                    stack = stack.causeBy((CauseBy)causeBy.get());
                    stackLines = stack.currentStackLines();
                    continue;
                }
                Optional<More> more = More.match(line);
                if (more.isPresent()) {
                    lastOneWasCauseBy = false;
                    stackLines.more((More)more.get());
                    stackLines = stack.newStackLines();
                    continue;
                }
                if (lastOneWasCauseBy) {
                    stack.addMessage(line);
                    continue;
                }
                throw new RuntimeException("unknown type of line: " + line);
            }
            return StackTraceMatcher.toStackTrace(lines, this._stack);
        }
    }
}

