/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher.stacktrace;

import com.google.common.base.Optional;
import de.flapdoodle.logparser.matcher.CustomPatterns;
import de.flapdoodle.logparser.matcher.stacktrace.AbstractStackElement;
import de.flapdoodle.logparser.regex.Patterns;
import java.util.Map;
import java.util.regex.Pattern;

public class CauseBy
extends AbstractStackElement {
    private static final String EXCEPTION = "exception";
    private static final String MESSAGE = "message";
    private static final Pattern PATTERN = Patterns.join(Pattern.compile("Caused"), CustomPatterns.Space, Pattern.compile("by:"), CustomPatterns.Space, Patterns.namedGroup("exception", CustomPatterns.Classname), Pattern.compile(": "), Patterns.namedGroup("message", Pattern.compile(".*$")));

    protected CauseBy(String line, Map<String, String> attributes) {
        super(line, attributes);
    }

    public String exception() {
        return this.attribute(EXCEPTION);
    }

    public String message() {
        return this.attribute(MESSAGE);
    }

    public static boolean find(CharSequence input) {
        return Patterns.find(PATTERN, input);
    }

    public static Optional<CauseBy> match(CharSequence input) {
        return CauseBy.match(input, PATTERN, new AbstractStackElement.IStackElementFactory<CauseBy>(){

            @Override
            public CauseBy newInstance(String line, Map<String, String> attributes) {
                return new CauseBy(line, attributes);
            }
        });
    }
}

