/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher.stacktrace;

import com.google.common.base.Optional;
import de.flapdoodle.logparser.matcher.CustomPatterns;
import de.flapdoodle.logparser.matcher.stacktrace.AbstractStackElement;
import de.flapdoodle.logparser.regex.Patterns;
import java.util.Map;
import java.util.regex.Pattern;

public class At
extends AbstractStackElement {
    private static final String LINE_NR = "line";
    private static final String FILE = "file";
    private static final String METHOD = "method";
    private static final String CLASSNAME = "class";
    private static final Pattern PATTERN = Patterns.join(Pattern.compile("^"), CustomPatterns.Space, Pattern.compile("at"), CustomPatterns.Space, Patterns.namedGroup("class", CustomPatterns.Classname), Pattern.compile("\\."), Patterns.namedGroup("method", CustomPatterns.Method), Pattern.compile("\\("), Patterns.group(Pattern.compile("Native Method"), Pattern.compile("|"), Patterns.namedGroup("file", "([a-zA-Z][a-zA-Z0-9]+)\\.java"), Pattern.compile(":"), Patterns.namedGroup("line", "\\d+")), Pattern.compile("\\)"));

    protected At(String line, Map<String, String> attributes) {
        super(line, attributes);
    }

    public String classname() {
        return this.attribute(CLASSNAME);
    }

    public String method() {
        return this.attribute(METHOD);
    }

    public String file() {
        return this.attribute(FILE);
    }

    public String lineNr() {
        return this.attribute(LINE_NR);
    }

    public static boolean find(CharSequence input) {
        return Patterns.find(PATTERN, input);
    }

    public static Optional<At> match(CharSequence input) {
        return At.match(input, PATTERN, new AbstractStackElement.IStackElementFactory<At>(){

            @Override
            public At newInstance(String line, Map<String, String> attributes) {
                return new At(line, attributes);
            }
        });
    }
}

