/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher.stacktrace;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import de.flapdoodle.logparser.regex.Patterns;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractStackElement {
    private final String _line;
    private final ImmutableMap<String, String> _attributes;

    protected AbstractStackElement(String line, Map<String, String> attributes) {
        this._line = line;
        this._attributes = ImmutableMap.copyOf(attributes);
    }

    protected String attribute(String key) {
        return (String)this._attributes.get((Object)key);
    }

    public ImmutableMap<String, String> attributes() {
        return this._attributes;
    }

    public String line() {
        return this._line;
    }

    protected static <T> Optional<T> match(CharSequence input, Pattern pattern, IStackElementFactory<T> factory) {
        Optional<Map<String, String>> m = Patterns.match(pattern.matcher(input));
        if (m.isPresent()) {
            return Optional.of(factory.newInstance(input.toString(), (Map)m.get()));
        }
        return Optional.absent();
    }

    static interface IStackElementFactory<T> {
        public T newInstance(String var1, Map<String, String> var2);
    }
}

