/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher.generic;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.flapdoodle.logparser.IBackBuffer;
import de.flapdoodle.logparser.IMatch;
import de.flapdoodle.logparser.IMatcher;
import de.flapdoodle.logparser.IReader;
import de.flapdoodle.logparser.LogEntry;
import de.flapdoodle.logparser.StreamProcessor;
import de.flapdoodle.logparser.io.StringListReaderAdapter;
import de.flapdoodle.logparser.io.WriteToListLineProcessor;
import de.flapdoodle.logparser.matcher.stacktrace.StackTraceMatcher;
import de.flapdoodle.logparser.regex.Patterns;
import de.flapdoodle.logparser.stacktrace.StackTrace;
import de.flapdoodle.logparser.streamlistener.OnceAndOnlyOnceStreamListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class GenericLogMatcher
implements IMatcher<LogEntry> {
    private final ImmutableList<Pattern> firstLinesPatterns;
    private final Map<Pattern, Set<String>> names = Maps.newHashMap();

    public GenericLogMatcher(Pattern firstLine, Pattern ... additionalLines) {
        this.firstLinesPatterns = ImmutableList.builder().add((Object)firstLine).add((Object[])additionalLines).build();
        for (Pattern p : this.firstLinesPatterns) {
            this.names.put(p, Patterns.names(p));
        }
    }

    @Override
    public Optional<IMatch<LogEntry>> match(IReader reader, IBackBuffer backBuffer) throws IOException {
        ArrayList lines = Lists.newArrayList();
        for (Pattern p : this.firstLinesPatterns) {
            Optional<String> possibleLine = reader.nextLine();
            if (possibleLine.isPresent()) {
                Optional<Map<String, String>> match = Patterns.match(p.matcher((CharSequence)possibleLine.get()), this.names.get(p));
                if (match.isPresent()) {
                    lines.add(new LineWithMatch((String)possibleLine.get(), (Map)match.get()));
                    continue;
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
        return Optional.of((Object)new Match(lines));
    }

    static String asString(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        sb.append("-----------------------------------\n");
        for (String line : lines) {
            sb.append(line);
            sb.append("\n");
        }
        sb.append("-----------------------------------\n");
        return sb.toString();
    }

    static class StackTraceParseException
    extends RuntimeException {
        public StackTraceParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class Match
    implements IMatch<LogEntry> {
        private final ImmutableList<LineWithMatch> lines;

        public Match(List<LineWithMatch> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }

        @Override
        public LogEntry process(List<String> lines) throws IOException {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)Lists.transform(this.lines, (Function)new Function<LineWithMatch, String>(){

                public String apply(LineWithMatch input) {
                    return input.line();
                }
            }));
            builder.addAll(lines);
            ImmutableList allLines = builder.build();
            List attributes = Lists.transform(this.lines, (Function)new Function<LineWithMatch, Map<String, String>>(){

                public Map<String, String> apply(LineWithMatch input) {
                    return input.attributes();
                }
            });
            Optional stackTrace = Optional.absent();
            ImmutableList<String> messages = ImmutableList.of();
            if (!lines.isEmpty()) {
                OnceAndOnlyOnceStreamListener stackTraceListener = new OnceAndOnlyOnceStreamListener();
                WriteToListLineProcessor contentListener = new WriteToListLineProcessor();
                StreamProcessor contentProcessor = new StreamProcessor(Lists.newArrayList((Object[])new IMatcher[]{new StackTraceMatcher()}), contentListener, stackTraceListener);
                try {
                    contentProcessor.process(new StringListReaderAdapter(lines));
                }
                catch (RuntimeException iax) {
                    throw new StackTraceParseException(GenericLogMatcher.asString(lines), iax);
                }
                stackTrace = stackTraceListener.value();
                messages = contentListener.lines();
            }
            return new LogEntry((List<String>)allLines, LogEntry.join(attributes), (Optional<StackTrace>)stackTrace, (List<String>)messages);
        }
    }

    static class LineWithMatch {
        private final String line;
        private final ImmutableMap<String, String> attributes;

        public LineWithMatch(String line, Map<String, String> attributes) {
            this.line = line;
            this.attributes = ImmutableMap.copyOf(attributes);
        }

        public String line() {
            return this.line;
        }

        public ImmutableMap<String, String> attributes() {
            return this.attributes;
        }
    }
}

