/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.matcher;

import java.util.logging.Level;
import java.util.regex.Pattern;

public class CustomPatterns {
    public static final Pattern Space = Pattern.compile("\\s+");
    public static final Pattern Method = Pattern.compile("([a-zA-Z][a-zA-Z0-9\\$]*)");
    public static final Pattern Classname = Pattern.compile("([a-zA-Z]+)((\\.|\\$)[a-zA-Z][a-zA-Z\\$0-9]*)*");
    public static final Pattern Date = Pattern.compile("([a-zA-Z]+) ([0-2]\\d|3[01]), (19|20|21)(\\d\\d) (1\\d|2\\d|\\d):([0-5][0-9]):([0-5][0-9]) (AM|PM)");
    public static final Pattern Levels = Pattern.compile(CustomPatterns.allLevels());

    private CustomPatterns() {
    }

    static String allLevels() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        CustomPatterns.appendLevel(sb, Level.CONFIG);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.FINE);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.FINER);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.FINEST);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.INFO);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.SEVERE);
        sb.append("|");
        CustomPatterns.appendLevel(sb, Level.WARNING);
        sb.append(")");
        return sb.toString();
    }

    static void appendLevel(StringBuilder sb, Level level) {
        sb.append(level.getName());
    }
}

