/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.io;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.flapdoodle.logparser.IRewindableReader;
import java.io.IOException;
import java.util.List;

public class StringListReaderAdapter
implements IRewindableReader {
    private final List<String> _lines;
    int _idx = 0;
    int _marker = -1;

    public StringListReaderAdapter(List<String> lines) {
        this._lines = ImmutableList.copyOf(lines);
    }

    @Override
    public synchronized Optional<String> nextLine() throws IOException {
        if (this._idx < this._lines.size()) {
            String line = this._lines.get(this._idx);
            ++this._idx;
            return Optional.of((Object)line);
        }
        return Optional.absent();
    }

    @Override
    public synchronized void setMarker() throws IOException {
        this._marker = this._idx;
    }

    @Override
    public synchronized void jumpToMarker() throws IOException {
        if (this._marker == -1) {
            throw new IOException("marker not set");
        }
        this._idx = this._marker;
    }
}

