/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser.io;

import com.google.common.base.Optional;
import de.flapdoodle.logparser.IRewindableReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class BufferedReaderAdapter
implements IRewindableReader {
    private final BufferedReader _reader;
    private final int _readAheadLimit;

    public BufferedReaderAdapter(InputStream stream, Charset charset, int readAheadLimit) {
        this._readAheadLimit = readAheadLimit;
        this._reader = new BufferedReader(new InputStreamReader(stream, charset));
    }

    @Override
    public Optional<String> nextLine() throws IOException {
        String line = this._reader.readLine();
        return line != null ? Optional.of((Object)line) : Optional.absent();
    }

    @Override
    public void setMarker() throws IOException {
        this._reader.mark(this._readAheadLimit);
    }

    @Override
    public void jumpToMarker() throws IOException {
        this._reader.reset();
    }
}

