/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.flapdoodle.logparser.IBackBuffer;
import de.flapdoodle.logparser.ILineProcessor;
import de.flapdoodle.logparser.IMatch;
import de.flapdoodle.logparser.IMatcher;
import de.flapdoodle.logparser.IRewindableReader;
import de.flapdoodle.logparser.IStreamListener;
import de.flapdoodle.logparser.IStreamProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamProcessor<T>
implements IStreamProcessor<T> {
    private final ImmutableList<? extends IMatcher<T>> _matcher;
    private final ILineProcessor _defaultLineProcessor;
    private final IStreamListener<T> _listener;
    private static final int OFFSET = 1000;

    public StreamProcessor(Collection<? extends IMatcher<T>> matcher, ILineProcessor defaultLineProcessor, IStreamListener<T> listener) {
        this._matcher = ImmutableList.copyOf(matcher);
        this._defaultLineProcessor = defaultLineProcessor;
        this._listener = listener;
    }

    @Override
    public void process(IRewindableReader reader) throws IOException {
        boolean eof = false;
        do {
            Optional<IMatch<T>> match;
            if ((match = this.firstMatch(reader, new EmtpyBackBuffer())).isPresent()) {
                this.process(reader, match);
                continue;
            }
            Optional<String> nextLine = reader.nextLine();
            if (nextLine.isPresent()) {
                this._defaultLineProcessor.processLine((String)nextLine.get());
                continue;
            }
            eof = true;
        } while (!eof);
    }

    private void process(IRewindableReader reader, Optional<IMatch<T>> match) throws IOException {
        ArrayList nonMatchingLines = Lists.newArrayList();
        BackBufferFromList backBuffer = new BackBufferFromList(nonMatchingLines);
        boolean readDone = false;
        int lines = 0;
        int showNumberAt = lines + 1000;
        do {
            Optional<IMatch<T>> nextMatch;
            if ((nextMatch = this.firstMatch(reader, backBuffer)).isPresent()) {
                Object result = ((IMatch)match.get()).process(nonMatchingLines);
                this._listener.entry(result);
                nonMatchingLines = Lists.newArrayList();
            } else {
                Optional<String> nextLine = reader.nextLine();
                if (nextLine.isPresent()) {
                    nonMatchingLines.add(nextLine.get());
                } else {
                    Object result = ((IMatch)match.get()).process(nonMatchingLines);
                    this._listener.entry(result);
                    nonMatchingLines = Lists.newArrayList();
                    readDone = true;
                }
            }
            if (++lines < showNumberAt) continue;
            System.out.print("\r" + lines);
            showNumberAt = lines + 1000;
        } while (!readDone);
    }

    private Optional<IMatch<T>> firstMatch(IRewindableReader reader, IBackBuffer backBuffer) throws IOException {
        reader.setMarker();
        for (IMatcher matcher : this._matcher) {
            Optional match = matcher.match(reader, backBuffer);
            if (match.isPresent()) {
                return match;
            }
            reader.jumpToMarker();
        }
        return Optional.absent();
    }

    static class EmtpyBackBuffer
    implements IBackBuffer {
        EmtpyBackBuffer() {
        }

        @Override
        public ImmutableList<String> lastLines() {
            return ImmutableList.of();
        }
    }

    static class BackBufferFromList
    implements IBackBuffer {
        private final List<String> _lines;

        public BackBufferFromList(List<String> lines) {
            this._lines = lines;
        }

        @Override
        public ImmutableList<String> lastLines() {
            return ImmutableList.copyOf((Collection)Lists.reverse(this._lines));
        }
    }
}

