/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.logparser;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.flapdoodle.logparser.stacktrace.StackTrace;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogEntry {
    private final ImmutableList<String> _source;
    private final ImmutableMap<String, String> _attributes;
    private final Optional<StackTrace> _stackTrace;
    private final ImmutableList<String> _messages;

    public LogEntry(List<String> source, Map<String, String> attributes, Optional<StackTrace> stackTrace, List<String> messages) {
        this._source = ImmutableList.copyOf(source);
        this._attributes = ImmutableMap.copyOf(attributes);
        this._stackTrace = stackTrace;
        this._messages = ImmutableList.copyOf(messages);
    }

    public ImmutableMap<String, String> attributes() {
        return this._attributes;
    }

    public Optional<StackTrace> stackTrace() {
        return this._stackTrace;
    }

    public ImmutableList<String> messages() {
        return this._messages;
    }

    public ImmutableList<String> source() {
        return this._source;
    }

    public static Map<String, String> join(Collection<? extends Map<String, String>> maps) {
        Map<Object, Object> ret = Maps.newHashMap();
        for (Map<String, String> map : maps) {
            ret = LogEntry.join(ret, map);
        }
        return ret;
    }

    public static Map<String, String> join(Map<String, String> ... maps) {
        Map<Object, Object> ret = Maps.newHashMap();
        for (Map<String, String> map : maps) {
            ret = LogEntry.join(ret, map);
        }
        return ret;
    }

    private static <K, V> Map<K, V> join(Map<K, V> a, Map<K, V> b) {
        HashMap ret = Maps.newHashMap(a);
        ret.putAll(b);
        if (ret.size() != a.size() + b.size()) {
            throw new RuntimeException("Map contains same keys: " + Sets.intersection(a.keySet(), b.keySet()));
        }
        return b;
    }
}

