package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Self}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSelf.of()}.
 */
@Generated(from = "Self", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSelf<X> extends Self<X> {
  private final Value<X> destination;
  private final V0<X> validation;

  private ImmutableSelf(
      Value<X> destination,
      V0<X> validation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.validation = Objects.requireNonNull(validation, "validation");
  }

  private ImmutableSelf(
      ImmutableSelf<X> original,
      Value<X> destination,
      V0<X> validation) {
    this.destination = destination;
    this.validation = validation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  protected V0<X> validation() {
    return validation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Self#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelf<X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableSelf<>(this, newValue, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Self#validation() validation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelf<X> withValidation(V0<X> value) {
    if (this.validation == value) return this;
    V0<X> newValue = Objects.requireNonNull(value, "validation");
    return new ImmutableSelf<>(this, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSelf} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSelf<?>
        && equalTo(0, (ImmutableSelf<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSelf<?> another) {
    return destination.equals(another.destination)
        && validation.equals(another.validation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code validation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + validation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Self} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Self")
        .omitNullValues()
        .add("destination", destination)
        .add("validation", validation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Self} instance.
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param validation The value for the {@code validation} attribute
   * @return An immutable Self instance
   */
  public static <X> ImmutableSelf<X> of(Value<X> destination, V0<X> validation) {
    return new ImmutableSelf<>(destination, validation);
  }

  /**
   * Creates an immutable copy of a {@link Self} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Self instance
   */
  public static <X> ImmutableSelf<X> copyOf(Self<X> instance) {
    if (instance instanceof ImmutableSelf<?>) {
      return (ImmutableSelf<X>) instance;
    }
    return ImmutableSelf.<X>of(instance.destination(), instance.validation());
  }
}
