package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelatedTo1}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRelatedTo1.of()}.
 */
@Generated(from = "RelatedTo1", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelatedTo1<X, A>
    extends RelatedTo1<X, A> {
  private final Value<X> destination;
  private final ValueSource<A> source;
  private final V1<X, A> validation;

  private ImmutableRelatedTo1(
      Value<X> destination,
      ValueSource<A> source,
      V1<X, A> validation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.source = Objects.requireNonNull(source, "source");
    this.validation = Objects.requireNonNull(validation, "validation");
  }

  private ImmutableRelatedTo1(
      ImmutableRelatedTo1<X, A> original,
      Value<X> destination,
      ValueSource<A> source,
      V1<X, A> validation) {
    this.destination = destination;
    this.source = source;
    this.validation = validation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  protected ValueSource<A> source() {
    return source;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  protected V1<X, A> validation() {
    return validation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo1#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo1<X, A> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableRelatedTo1<>(this, newValue, this.source, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo1#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo1<X, A> withSource(ValueSource<A> value) {
    if (this.source == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableRelatedTo1<>(this, this.destination, newValue, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo1#validation() validation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo1<X, A> withValidation(V1<X, A> value) {
    if (this.validation == value) return this;
    V1<X, A> newValue = Objects.requireNonNull(value, "validation");
    return new ImmutableRelatedTo1<>(this, this.destination, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelatedTo1} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelatedTo1<?, ?>
        && equalTo(0, (ImmutableRelatedTo1<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelatedTo1<?, ?> another) {
    return destination.equals(another.destination)
        && source.equals(another.source)
        && validation.equals(another.validation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code source}, {@code validation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + validation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelatedTo1} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RelatedTo1")
        .omitNullValues()
        .add("destination", destination)
        .add("source", source)
        .add("validation", validation)
        .toString();
  }

  /**
   * Construct a new immutable {@code RelatedTo1} instance.
 * @param <X> generic parameter X
 * @param <A> generic parameter A
   * @param destination The value for the {@code destination} attribute
   * @param source The value for the {@code source} attribute
   * @param validation The value for the {@code validation} attribute
   * @return An immutable RelatedTo1 instance
   */
  public static <X, A> ImmutableRelatedTo1<X, A> of(Value<X> destination, ValueSource<A> source, V1<X, A> validation) {
    return new ImmutableRelatedTo1<>(destination, source, validation);
  }

  /**
   * Creates an immutable copy of a {@link RelatedTo1} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param <A> generic parameter A
   * @param instance The instance to copy
   * @return A copied immutable RelatedTo1 instance
   */
  public static <X, A> ImmutableRelatedTo1<X, A> copyOf(RelatedTo1<X, A> instance) {
    if (instance instanceof ImmutableRelatedTo1<?, ?>) {
      return (ImmutableRelatedTo1<X, A>) instance;
    }
    return ImmutableRelatedTo1.<X, A>of(instance.destination(), instance.source(), instance.validation());
  }
}
