package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StrictValueLookup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStrictValueLookup.builder()}.
 */
@Generated(from = "StrictValueLookup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStrictValueLookup extends StrictValueLookup {
  private final ImmutableList<MappedValue<?>> entries;

  private ImmutableStrictValueLookup(ImmutableList<MappedValue<?>> entries) {
    this.entries = entries;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @Override
  protected ImmutableList<MappedValue<?>> entries() {
    return entries;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StrictValueLookup#entries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableStrictValueLookup withEntries(MappedValue<?>... elements) {
    ImmutableList<MappedValue<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableStrictValueLookup(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StrictValueLookup#entries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStrictValueLookup withEntries(Iterable<? extends MappedValue<?>> elements) {
    if (this.entries == elements) return this;
    ImmutableList<MappedValue<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableStrictValueLookup(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStrictValueLookup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStrictValueLookup
        && equalTo(0, (ImmutableStrictValueLookup) another);
  }

  private boolean equalTo(int synthetic, ImmutableStrictValueLookup another) {
    return entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StrictValueLookup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StrictValueLookup")
        .omitNullValues()
        .add("entries", entries)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long VALUES_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Map<Value<?>, Object> values;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link StrictValueLookup#values() values} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code values} attribute
   */
  @Override
  protected Map<Value<?>, Object> values() {
    if ((lazyInitBitmap & VALUES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUES_LAZY_INIT_BIT) == 0) {
          this.values = Objects.requireNonNull(super.values(), "values");
          lazyInitBitmap |= VALUES_LAZY_INIT_BIT;
        }
      }
    }
    return values;
  }

  private static final long NULL_VALUES_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Set<Value<?>> nullValues;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link StrictValueLookup#nullValues() nullValues} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code nullValues} attribute
   */
  @Override
  protected Set<Value<?>> nullValues() {
    if ((lazyInitBitmap & NULL_VALUES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & NULL_VALUES_LAZY_INIT_BIT) == 0) {
          this.nullValues = Objects.requireNonNull(super.nullValues(), "nullValues");
          lazyInitBitmap |= NULL_VALUES_LAZY_INIT_BIT;
        }
      }
    }
    return nullValues;
  }

  private static ImmutableStrictValueLookup validate(ImmutableStrictValueLookup instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link StrictValueLookup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StrictValueLookup instance
   */
  public static ImmutableStrictValueLookup copyOf(StrictValueLookup instance) {
    if (instance instanceof ImmutableStrictValueLookup) {
      return (ImmutableStrictValueLookup) instance;
    }
    return ImmutableStrictValueLookup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStrictValueLookup ImmutableStrictValueLookup}.
   * <pre>
   * ImmutableStrictValueLookup.builder()
   *    .addEntries|addAllEntries(de.flapdoodle.formula.calculate.MappedValue&amp;lt;?&amp;gt;) // {@link StrictValueLookup#entries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStrictValueLookup builder
   */
  public static ImmutableStrictValueLookup.Builder builder() {
    return new ImmutableStrictValueLookup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStrictValueLookup ImmutableStrictValueLookup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StrictValueLookup", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<MappedValue<?>> entries = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StrictValueLookup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StrictValueLookup instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEntries(instance.entries());
      return this;
    }

    /**
     * Adds one element to {@link StrictValueLookup#entries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(MappedValue<?> element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StrictValueLookup#entries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addEntries(MappedValue<?>... elements) {
      this.entries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StrictValueLookup#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entries(Iterable<? extends MappedValue<?>> elements) {
      this.entries = ImmutableList.builder();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link StrictValueLookup#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntries(Iterable<? extends MappedValue<?>> elements) {
      this.entries.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStrictValueLookup ImmutableStrictValueLookup}.
     * @return An immutable instance of StrictValueLookup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStrictValueLookup build() {
      return ImmutableStrictValueLookup.validate(new ImmutableStrictValueLookup(entries.build()));
    }
  }
}
