package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.types.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValidatedValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValidatedValue.builder()}.
 */
@Generated(from = "ValidatedValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValidatedValue<T> extends ValidatedValue<T> {
  private final ValueSource<T> source;
  private final Either<T, ValidationError> valueOrError;

  private ImmutableValidatedValue(
      ValueSource<T> source,
      Either<T, ValidationError> valueOrError) {
    this.source = source;
    this.valueOrError = valueOrError;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public ValueSource<T> source() {
    return source;
  }

  /**
   * @return The value of the {@code valueOrError} attribute
   */
  @Override
  public Either<T, ValidationError> valueOrError() {
    return valueOrError;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValidatedValue#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValidatedValue<T> withSource(ValueSource<T> value) {
    if (this.source == value) return this;
    ValueSource<T> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableValidatedValue<>(newValue, this.valueOrError);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValidatedValue#valueOrError() valueOrError} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueOrError
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValidatedValue<T> withValueOrError(Either<T, ValidationError> value) {
    if (this.valueOrError == value) return this;
    Either<T, ValidationError> newValue = Objects.requireNonNull(value, "valueOrError");
    return new ImmutableValidatedValue<>(this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValidatedValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValidatedValue<?>
        && equalTo(0, (ImmutableValidatedValue<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableValidatedValue<?> another) {
    return source.equals(another.source)
        && valueOrError.equals(another.valueOrError);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code valueOrError}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + valueOrError.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValidatedValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValidatedValue")
        .omitNullValues()
        .add("source", source)
        .add("valueOrError", valueOrError)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long IS_VALID_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient boolean isValid;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidatedValue#isValid() isValid} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code isValid} attribute
   */
  @Override
  public boolean isValid() {
    if ((lazyInitBitmap & IS_VALID_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & IS_VALID_LAZY_INIT_BIT) == 0) {
          this.isValid = super.isValid();
          lazyInitBitmap |= IS_VALID_LAZY_INIT_BIT;
        }
      }
    }
    return isValid;
  }

  private static final long ERRORS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<ErrorMessage> errors;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidatedValue#errors() errors} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code errors} attribute
   */
  @Override
  public List<ErrorMessage> errors() {
    if ((lazyInitBitmap & ERRORS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ERRORS_LAZY_INIT_BIT) == 0) {
          this.errors = Objects.requireNonNull(super.errors(), "errors");
          lazyInitBitmap |= ERRORS_LAZY_INIT_BIT;
        }
      }
    }
    return errors;
  }

  private static final long VALUE_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient T value;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidatedValue#value() value} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code value} attribute
   */
  @Override
  public T value() {
    if ((lazyInitBitmap & VALUE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUE_LAZY_INIT_BIT) == 0) {
          this.value = super.value();
          lazyInitBitmap |= VALUE_LAZY_INIT_BIT;
        }
      }
    }
    return value;
  }

  private static final long INVALID_REFERENCES_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient Set<? extends ValueSource<?>> invalidReferences;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidatedValue#invalidReferences() invalidReferences} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code invalidReferences} attribute
   */
  @Override
  public Set<? extends ValueSource<?>> invalidReferences() {
    if ((lazyInitBitmap & INVALID_REFERENCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & INVALID_REFERENCES_LAZY_INIT_BIT) == 0) {
          this.invalidReferences = Objects.requireNonNull(super.invalidReferences(), "invalidReferences");
          lazyInitBitmap |= INVALID_REFERENCES_LAZY_INIT_BIT;
        }
      }
    }
    return invalidReferences;
  }

  /**
   * Creates an immutable copy of a {@link ValidatedValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ValidatedValue instance
   */
  public static <T> ImmutableValidatedValue<T> copyOf(ValidatedValue<T> instance) {
    if (instance instanceof ImmutableValidatedValue<?>) {
      return (ImmutableValidatedValue<T>) instance;
    }
    return ImmutableValidatedValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValidatedValue ImmutableValidatedValue}.
   * <pre>
   * ImmutableValidatedValue.&amp;lt;T&amp;gt;builder()
   *    .source(de.flapdoodle.formula.ValueSource&amp;lt;T&amp;gt;) // required {@link ValidatedValue#source() source}
   *    .valueOrError(de.flapdoodle.formula.types.Either&amp;lt;T, de.flapdoodle.formula.validation.ValidationError&amp;gt;) // required {@link ValidatedValue#valueOrError() valueOrError}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param source {@code source} parameter
   * @return A new ImmutableValidatedValue builder
   */
  public static <T> ImmutableValidatedValue.Builder<T> builder(ValueSource<T> source) {
    return new ImmutableValidatedValue.Builder<>(source);
  }

  static <T> ImmutableValidatedValue.Builder<T> builder() {
    return new ImmutableValidatedValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableValidatedValue ImmutableValidatedValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValidatedValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_VALUE_OR_ERROR = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ValueSource<T> source;
    private @Nullable Either<T, ValidationError> valueOrError;

    private Builder(ValueSource<T> source) {
      source(source);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValidatedValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ValidatedValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.source());
      valueOrError(instance.valueOrError());
      return this;
    }

    /**
     * Initializes the value for the {@link ValidatedValue#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder<T> source(ValueSource<T> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link ValidatedValue#valueOrError() valueOrError} attribute.
     * @param valueOrError The value for valueOrError 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> valueOrError(Either<T, ValidationError> valueOrError) {
      this.valueOrError = Objects.requireNonNull(valueOrError, "valueOrError");
      initBits &= ~INIT_BIT_VALUE_OR_ERROR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValidatedValue ImmutableValidatedValue}.
     * @return An immutable instance of ValidatedValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValidatedValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValidatedValue<>(source, valueOrError);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_VALUE_OR_ERROR) != 0) attributes.add("valueOrError");
      return "Cannot build ValidatedValue, some of required attributes are not set " + attributes;
    }
  }
}
