package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorMessage.builder()}.
 */
@Generated(from = "ErrorMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableErrorMessage implements ErrorMessage {
  private final String key;
  private final ImmutableList<Object> args;

  private ImmutableErrorMessage(ImmutableErrorMessage.Builder builder) {
    this.key = builder.key;
    this.args = builder.argsIsSet()
        ? builder.args.build()
        : ImmutableList.copyOf(ErrorMessage.super.args());
  }

  private ImmutableErrorMessage(String key, ImmutableList<Object> args) {
    this.key = key;
    this.args = args;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public ImmutableList<Object> args() {
    return args;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorMessage#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorMessage withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableErrorMessage(newValue, this.args);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorMessage#args() args}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErrorMessage withArgs(Object... elements) {
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErrorMessage(this.key, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorMessage#args() args}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of args elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErrorMessage withArgs(Iterable<? extends Object> elements) {
    if (this.args == elements) return this;
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErrorMessage(this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorMessage
        && equalTo(0, (ImmutableErrorMessage) another);
  }

  private boolean equalTo(int synthetic, ImmutableErrorMessage another) {
    return key.equals(another.key)
        && args.equals(another.args);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + args.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorMessage")
        .omitNullValues()
        .add("key", key)
        .add("args", args)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ErrorMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorMessage instance
   */
  public static ImmutableErrorMessage copyOf(ErrorMessage instance) {
    if (instance instanceof ImmutableErrorMessage) {
      return (ImmutableErrorMessage) instance;
    }
    return ImmutableErrorMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorMessage ImmutableErrorMessage}.
   * <pre>
   * ImmutableErrorMessage.builder()
   *    .key(String) // required {@link ErrorMessage#key() key}
   *    .addArgs|addAllArgs(Object) // {@link ErrorMessage#args() args} elements
   *    .build();
   * </pre>
   * @return A new ImmutableErrorMessage builder
   */
  public static ImmutableErrorMessage.Builder builder() {
    return new ImmutableErrorMessage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorMessage ImmutableErrorMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorMessage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long OPT_BIT_ARGS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String key;
    private ImmutableList.Builder<Object> args = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErrorMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorMessage instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.key());
      addAllArgs(instance.args());
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorMessage#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Adds one element to {@link ErrorMessage#args() args} list.
     * @param element A args element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(Object element) {
      this.args.add(element);
      optBits |= OPT_BIT_ARGS;
      return this;
    }

    /**
     * Adds elements to {@link ErrorMessage#args() args} list.
     * @param elements An array of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(Object... elements) {
      this.args.add(elements);
      optBits |= OPT_BIT_ARGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ErrorMessage#args() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Iterable<? extends Object> elements) {
      this.args = ImmutableList.builder();
      return addAllArgs(elements);
    }

    /**
     * Adds elements to {@link ErrorMessage#args() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArgs(Iterable<? extends Object> elements) {
      this.args.addAll(elements);
      optBits |= OPT_BIT_ARGS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorMessage ImmutableErrorMessage}.
     * @return An immutable instance of ErrorMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableErrorMessage(this);
    }

    private boolean argsIsSet() {
      return (optBits & OPT_BIT_ARGS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
    }
  }
}
