package de.flapdoodle.formula.types;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Maybe.Some}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSome.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSome.of()}.
 */
@Generated(from = "Maybe.Some", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSome<T> extends Maybe.Some<T> {
  private final @Nullable T value;

  private ImmutableSome(@Nullable T value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  protected @Nullable T value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Maybe.Some#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSome<T> withValue(@Nullable T value) {
    if (this.value == value) return this;
    return new ImmutableSome<>(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSome} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSome<?>
        && equalTo(0, (ImmutableSome<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSome<?> another) {
    return Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Some} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Some")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code Some} instance.
 * @param <T> generic parameter T
   * @param value The value for the {@code value} attribute
   * @return An immutable Some instance
   */
  public static <T> ImmutableSome<T> of(@Nullable T value) {
    return new ImmutableSome<>(value);
  }

  /**
   * Creates an immutable copy of a {@link Maybe.Some} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Some instance
   */
  public static <T> ImmutableSome<T> copyOf(Maybe.Some<T> instance) {
    if (instance instanceof ImmutableSome<?>) {
      return (ImmutableSome<T>) instance;
    }
    return ImmutableSome.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSome ImmutableSome}.
   * <pre>
   * ImmutableSome.&amp;lt;T&amp;gt;builder()
   *    .value(T | null) // nullable {@link Maybe.Some#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableSome builder
   */
  public static <T> ImmutableSome.Builder<T> builder() {
    return new ImmutableSome.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableSome ImmutableSome}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Maybe.Some", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private @Nullable T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Some} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Maybe.Some<T> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable T valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Maybe.Some#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(@Nullable T value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSome ImmutableSome}.
     * @return An immutable instance of Some
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSome<T> build() {
      return new ImmutableSome<>(value);
    }
  }
}
