package de.flapdoodle.formula.solver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Explanation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExplanation.builder()}.
 */
@Generated(from = "Explanation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExplanation extends Explanation {
  private final ImmutableList<Explanation.ExplainValue<?>> list;

  private ImmutableExplanation(
      ImmutableList<Explanation.ExplainValue<?>> list) {
    this.list = list;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public ImmutableList<Explanation.ExplainValue<?>> list() {
    return list;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Explanation#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableExplanation withList(Explanation.ExplainValue<?>... elements) {
    ImmutableList<Explanation.ExplainValue<?>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExplanation(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Explanation#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExplanation withList(Iterable<? extends Explanation.ExplainValue<?>> elements) {
    if (this.list == elements) return this;
    ImmutableList<Explanation.ExplainValue<?>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExplanation(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExplanation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExplanation
        && equalTo(0, (ImmutableExplanation) another);
  }

  private boolean equalTo(int synthetic, ImmutableExplanation another) {
    return list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Explanation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Explanation")
        .omitNullValues()
        .add("list", list)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Explanation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Explanation instance
   */
  public static ImmutableExplanation copyOf(Explanation instance) {
    if (instance instanceof ImmutableExplanation) {
      return (ImmutableExplanation) instance;
    }
    return ImmutableExplanation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExplanation ImmutableExplanation}.
   * <pre>
   * ImmutableExplanation.builder()
   *    .addList|addAllList(de.flapdoodle.formula.solver.Explanation.ExplainValue&amp;lt;?&amp;gt;) // {@link Explanation#list() list} elements
   *    .build();
   * </pre>
   * @return A new ImmutableExplanation builder
   */
  public static ImmutableExplanation.Builder builder() {
    return new ImmutableExplanation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExplanation ImmutableExplanation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Explanation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Explanation.ExplainValue<?>> list = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Explanation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Explanation instance) {
      Objects.requireNonNull(instance, "instance");
      addAllList(instance.list());
      return this;
    }

    /**
     * Adds one element to {@link Explanation#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(Explanation.ExplainValue<?> element) {
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Explanation#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addList(Explanation.ExplainValue<?>... elements) {
      this.list.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Explanation#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(Iterable<? extends Explanation.ExplainValue<?>> elements) {
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link Explanation#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<? extends Explanation.ExplainValue<?>> elements) {
      this.list.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExplanation ImmutableExplanation}.
     * @return An immutable instance of Explanation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExplanation build() {
      return new ImmutableExplanation(list.build());
    }
  }
}
