package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN3.FN3WithLabel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN3WithLabel.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN3WithLabel.of()}.
 */
@Generated(from = "FN3.FN3WithLabel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN3WithLabel<A, B, C, R>
    extends FN3.FN3WithLabel<A, B, C, R> {
  private final FN3<A, B, C, R> delegate;
  private final String label;

  private ImmutableFN3WithLabel(FN3<A, B, C, R> delegate, String label) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.label = Objects.requireNonNull(label, "label");
  }

  private ImmutableFN3WithLabel(
      ImmutableFN3WithLabel<A, B, C, R> original,
      FN3<A, B, C, R> delegate,
      String label) {
    this.delegate = delegate;
    this.label = label;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected FN3<A, B, C, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  protected String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3WithLabel#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3WithLabel<A, B, C, R> withDelegate(FN3<A, B, C, R> value) {
    if (this.delegate == value) return this;
    FN3<A, B, C, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN3WithLabel<>(this, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3WithLabel#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3WithLabel<A, B, C, R> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableFN3WithLabel<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN3WithLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN3WithLabel<?, ?, ?, ?>
        && equalTo(0, (ImmutableFN3WithLabel<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN3WithLabel<?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN3WithLabel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN3WithLabel")
        .omitNullValues()
        .add("delegate", delegate)
        .add("label", label)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN3WithLabel} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param label The value for the {@code label} attribute
   * @return An immutable FN3WithLabel instance
   */
  public static <A, B, C, R> ImmutableFN3WithLabel<A, B, C, R> of(FN3<A, B, C, R> delegate, String label) {
    return new ImmutableFN3WithLabel<>(delegate, label);
  }

  /**
   * Creates an immutable copy of a {@link FN3.FN3WithLabel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN3WithLabel instance
   */
  public static <A, B, C, R> ImmutableFN3WithLabel<A, B, C, R> copyOf(FN3.FN3WithLabel<A, B, C, R> instance) {
    if (instance instanceof ImmutableFN3WithLabel<?, ?, ?, ?>) {
      return (ImmutableFN3WithLabel<A, B, C, R>) instance;
    }
    return ImmutableFN3WithLabel.<A, B, C, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN3WithLabel ImmutableFN3WithLabel}.
   * <pre>
   * ImmutableFN3WithLabel.&amp;lt;A, B, C, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.FN3&amp;lt;A, B, C, R&amp;gt;) // required {@link FN3.FN3WithLabel#delegate() delegate}
   *    .label(String) // required {@link FN3.FN3WithLabel#label() label}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @return A new ImmutableFN3WithLabel builder
   */
  public static <A, B, C, R> ImmutableFN3WithLabel.Builder<A, B, C, R> builder() {
    return new ImmutableFN3WithLabel.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN3WithLabel ImmutableFN3WithLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN3.FN3WithLabel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable FN3<A, B, C, R> delegate;
    private @Nullable String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN3WithLabel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> from(FN3.FN3WithLabel<A, B, C, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3WithLabel#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> delegate(FN3<A, B, C, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3WithLabel#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN3WithLabel ImmutableFN3WithLabel}.
     * @return An immutable instance of FN3WithLabel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN3WithLabel<A, B, C, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN3WithLabel<>(null, delegate, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build FN3WithLabel, some of required attributes are not set " + attributes;
    }
  }
}
