package de.flapdoodle.formula.calculate.functions;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN1.FN1Identity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN1Identity.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableFN1Identity.of()}.
 */
@Generated(from = "FN1.FN1Identity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN1Identity<X>
    extends FN1.FN1Identity<X> {

  private ImmutableFN1Identity() {}

  /**
   * This instance is equal to all instances of {@code ImmutableFN1Identity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN1Identity<?>
        && equalTo(0, (ImmutableFN1Identity<?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableFN1Identity<?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 2064636907;
  }

  /**
   * Prints the immutable value {@code FN1Identity}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FN1Identity{}";
  }

  @SuppressWarnings("raw")
  private static final ImmutableFN1Identity INSTANCE = validate(new ImmutableFN1Identity());

  /**
   * Returns the default immutable singleton value of {@code FN1Identity}
   * @return An immutable instance of FN1Identity
   */
  @SuppressWarnings("unchecked")
  public static <X> ImmutableFN1Identity<X> of() {
    return (ImmutableFN1Identity<X>) INSTANCE;
  }

  private static <X> ImmutableFN1Identity<X> validate(ImmutableFN1Identity<X> instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link FN1.FN1Identity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable FN1Identity instance
   */
  public static <X> ImmutableFN1Identity<X> copyOf(FN1.FN1Identity<X> instance) {
    if (instance instanceof ImmutableFN1Identity<?>) {
      return (ImmutableFN1Identity<X>) instance;
    }
    return ImmutableFN1Identity.<X>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN1Identity ImmutableFN1Identity}.
   * <pre>
   * ImmutableFN1Identity.&amp;lt;X&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <X> generic parameter X
   * @return A new ImmutableFN1Identity builder
   */
  public static <X> ImmutableFN1Identity.Builder<X> builder() {
    return new ImmutableFN1Identity.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN1Identity ImmutableFN1Identity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN1.FN1Identity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<X> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN1Identity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<X> from(FN1.FN1Identity<X> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN1Identity ImmutableFN1Identity}.
     * @return An immutable instance of FN1Identity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN1Identity<X> build() {
      return ImmutableFN1Identity.<X>of();
    }
  }
}
