package de.flapdoodle.formula.values;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Named}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNamed.of()}.
 */
@Generated(from = "Named", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNamed<T> extends Named<T> {
  private final @Nullable String name;
  private final Class<T> type;

  private ImmutableNamed(Optional<String> name, Class<T> type) {
    this.name = name.orElse(null);
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableNamed(
      ImmutableNamed<T> original,
      @Nullable String name,
      Class<T> type) {
    this.name = name;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  protected Optional<String> name() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  protected Class<T> type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Named#name() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNamed<T> withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableNamed<>(this, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Named#name() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNamed<T> withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableNamed<>(this, value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Named#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamed<T> withType(Class<T> value) {
    if (this.type == value) return this;
    Class<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableNamed<>(this, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamed} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamed<?>
        && equalTo(0, (ImmutableNamed<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableNamed<?> another) {
    return Objects.equals(name, another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Named} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Named")
        .omitNullValues()
        .add("name", name)
        .add("type", type)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long AS_HUMAN_READABLE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String asHumanReadable;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Named#asHumanReadable() asHumanReadable} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code asHumanReadable} attribute
   */
  @Override
  public String asHumanReadable() {
    if ((lazyInitBitmap & AS_HUMAN_READABLE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AS_HUMAN_READABLE_LAZY_INIT_BIT) == 0) {
          this.asHumanReadable = Objects.requireNonNull(super.asHumanReadable(), "asHumanReadable");
          lazyInitBitmap |= AS_HUMAN_READABLE_LAZY_INIT_BIT;
        }
      }
    }
    return asHumanReadable;
  }

  /**
   * Construct a new immutable {@code Named} instance.
 * @param <T> generic parameter T
   * @param name The value for the {@code name} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable Named instance
   */
  public static <T> ImmutableNamed<T> of(Optional<String> name, Class<T> type) {
    return new ImmutableNamed<>(name, type);
  }

  /**
   * Creates an immutable copy of a {@link Named} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Named instance
   */
  public static <T> ImmutableNamed<T> copyOf(Named<T> instance) {
    if (instance instanceof ImmutableNamed<?>) {
      return (ImmutableNamed<T>) instance;
    }
    return ImmutableNamed.<T>of(instance.name(), instance.type());
  }
}
