package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Validations.V2Explained}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableV2Explained.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableV2Explained.of()}.
 */
@Generated(from = "Validations.V2Explained", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableV2Explained<T, A, B>
    extends Validations.V2Explained<T, A, B> {
  private final Validations.V2<T, A, B> delegate;
  private final String humanReadable;

  private ImmutableV2Explained(Validations.V2<T, A, B> delegate, String humanReadable) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
  }

  private ImmutableV2Explained(
      ImmutableV2Explained<T, A, B> original,
      Validations.V2<T, A, B> delegate,
      String humanReadable) {
    this.delegate = delegate;
    this.humanReadable = humanReadable;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected Validations.V2<T, A, B> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code humanReadable} attribute
   */
  @Override
  protected String humanReadable() {
    return humanReadable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Validations.V2Explained#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV2Explained<T, A, B> withDelegate(Validations.V2<T, A, B> value) {
    if (this.delegate == value) return this;
    Validations.V2<T, A, B> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableV2Explained<>(this, newValue, this.humanReadable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Validations.V2Explained#humanReadable() humanReadable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for humanReadable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV2Explained<T, A, B> withHumanReadable(String value) {
    String newValue = Objects.requireNonNull(value, "humanReadable");
    if (this.humanReadable.equals(newValue)) return this;
    return new ImmutableV2Explained<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableV2Explained} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableV2Explained<?, ?, ?>
        && equalTo(0, (ImmutableV2Explained<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableV2Explained<?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && humanReadable.equals(another.humanReadable);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code humanReadable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + humanReadable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code V2Explained} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("V2Explained")
        .omitNullValues()
        .add("delegate", delegate)
        .add("humanReadable", humanReadable)
        .toString();
  }

  /**
   * Construct a new immutable {@code V2Explained} instance.
 * @param <T> generic parameter T
 * @param <A> generic parameter A
 * @param <B> generic parameter B
   * @param delegate The value for the {@code delegate} attribute
   * @param humanReadable The value for the {@code humanReadable} attribute
   * @return An immutable V2Explained instance
   */
  public static <T, A, B> ImmutableV2Explained<T, A, B> of(Validations.V2<T, A, B> delegate, String humanReadable) {
    return new ImmutableV2Explained<>(delegate, humanReadable);
  }

  /**
   * Creates an immutable copy of a {@link Validations.V2Explained} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param instance The instance to copy
   * @return A copied immutable V2Explained instance
   */
  public static <T, A, B> ImmutableV2Explained<T, A, B> copyOf(Validations.V2Explained<T, A, B> instance) {
    if (instance instanceof ImmutableV2Explained<?, ?, ?>) {
      return (ImmutableV2Explained<T, A, B>) instance;
    }
    return ImmutableV2Explained.<T, A, B>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableV2Explained ImmutableV2Explained}.
   * <pre>
   * ImmutableV2Explained.&amp;lt;T, A, B&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.validation.Validations.V2&amp;lt;T, A, B&amp;gt;) // required {@link Validations.V2Explained#delegate() delegate}
   *    .humanReadable(String) // required {@link Validations.V2Explained#humanReadable() humanReadable}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @return A new ImmutableV2Explained builder
   */
  public static <T, A, B> ImmutableV2Explained.Builder<T, A, B> builder() {
    return new ImmutableV2Explained.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableV2Explained ImmutableV2Explained}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Validations.V2Explained", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, A, B> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_HUMAN_READABLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Validations.V2<T, A, B> delegate;
    private @Nullable String humanReadable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code V2Explained} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B> from(Validations.V2Explained<T, A, B> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      humanReadable(instance.humanReadable());
      return this;
    }

    /**
     * Initializes the value for the {@link Validations.V2Explained#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B> delegate(Validations.V2<T, A, B> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Validations.V2Explained#humanReadable() humanReadable} attribute.
     * @param humanReadable The value for humanReadable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B> humanReadable(String humanReadable) {
      this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
      initBits &= ~INIT_BIT_HUMAN_READABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableV2Explained ImmutableV2Explained}.
     * @return An immutable instance of V2Explained
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableV2Explained<T, A, B> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableV2Explained<>(null, delegate, humanReadable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_HUMAN_READABLE) != 0) attributes.add("humanReadable");
      return "Cannot build V2Explained, some of required attributes are not set " + attributes;
    }
  }
}
