package de.flapdoodle.formula.types;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Maybe.None}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNone.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableNone.of()}.
 */
@Generated(from = "Maybe.None", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNone<T> extends Maybe.None<T> {

  private ImmutableNone() {}

  /**
   * This instance is equal to all instances of {@code ImmutableNone} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNone<?>
        && equalTo(0, (ImmutableNone<?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableNone<?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1096292435;
  }

  /**
   * Prints the immutable value {@code None}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "None{}";
  }

  @SuppressWarnings("raw")
  private static final ImmutableNone INSTANCE = validate(new ImmutableNone());

  /**
   * Returns the default immutable singleton value of {@code None}
   * @return An immutable instance of None
   */
  @SuppressWarnings("unchecked")
  public static <T> ImmutableNone<T> of() {
    return (ImmutableNone<T>) INSTANCE;
  }

  private static <T> ImmutableNone<T> validate(ImmutableNone<T> instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Maybe.None} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable None instance
   */
  public static <T> ImmutableNone<T> copyOf(Maybe.None<T> instance) {
    if (instance instanceof ImmutableNone<?>) {
      return (ImmutableNone<T>) instance;
    }
    return ImmutableNone.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNone ImmutableNone}.
   * <pre>
   * ImmutableNone.&amp;lt;T&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableNone builder
   */
  public static <T> ImmutableNone.Builder<T> builder() {
    return new ImmutableNone.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableNone ImmutableNone}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Maybe.None", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code None} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Maybe.None<T> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNone ImmutableNone}.
     * @return An immutable instance of None
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNone<T> build() {
      return ImmutableNone.<T>of();
    }
  }
}
