package de.flapdoodle.formula.solver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueContainer;
import de.flapdoodle.formula.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Context}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContext.builder()}.
 */
@Generated(from = "Context", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContext extends Context {
  private final ValueContainer unvalidated;
  private final ValueContainer validatedValues;
  private final ImmutableMap<Value<?>, ValidationError> validationErrorMap;

  private ImmutableContext(ImmutableContext.Builder builder) {
    this.validationErrorMap = builder.validationErrorMap.build();
    if (builder.unvalidated != null) {
      initShim.unvalidated(builder.unvalidated);
    }
    if (builder.validatedValues != null) {
      initShim.validatedValues(builder.validatedValues);
    }
    this.unvalidated = initShim.unvalidated();
    this.validatedValues = initShim.validatedValues();
    this.initShim = null;
  }

  private ImmutableContext(
      ValueContainer unvalidated,
      ValueContainer validatedValues,
      ImmutableMap<Value<?>, ValidationError> validationErrorMap) {
    this.unvalidated = unvalidated;
    this.validatedValues = validatedValues;
    this.validationErrorMap = validationErrorMap;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Context", generator = "Immutables")
  private final class InitShim {
    private byte unvalidatedBuildStage = STAGE_UNINITIALIZED;
    private ValueContainer unvalidated;

    ValueContainer unvalidated() {
      if (unvalidatedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (unvalidatedBuildStage == STAGE_UNINITIALIZED) {
        unvalidatedBuildStage = STAGE_INITIALIZING;
        this.unvalidated = Objects.requireNonNull(ImmutableContext.super.unvalidated(), "unvalidated");
        unvalidatedBuildStage = STAGE_INITIALIZED;
      }
      return this.unvalidated;
    }

    void unvalidated(ValueContainer unvalidated) {
      this.unvalidated = unvalidated;
      unvalidatedBuildStage = STAGE_INITIALIZED;
    }

    private byte validatedValuesBuildStage = STAGE_UNINITIALIZED;
    private ValueContainer validatedValues;

    ValueContainer validatedValues() {
      if (validatedValuesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (validatedValuesBuildStage == STAGE_UNINITIALIZED) {
        validatedValuesBuildStage = STAGE_INITIALIZING;
        this.validatedValues = Objects.requireNonNull(ImmutableContext.super.validatedValues(), "validatedValues");
        validatedValuesBuildStage = STAGE_INITIALIZED;
      }
      return this.validatedValues;
    }

    void validatedValues(ValueContainer validatedValues) {
      this.validatedValues = validatedValues;
      validatedValuesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (unvalidatedBuildStage == STAGE_INITIALIZING) attributes.add("unvalidated");
      if (validatedValuesBuildStage == STAGE_INITIALIZING) attributes.add("validatedValues");
      return "Cannot build Context, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code unvalidated} attribute
   */
  @Override
  protected ValueContainer unvalidated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.unvalidated()
        : this.unvalidated;
  }

  /**
   * @return The value of the {@code validatedValues} attribute
   */
  @Override
  protected ValueContainer validatedValues() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.validatedValues()
        : this.validatedValues;
  }

  /**
   * @return The value of the {@code validationErrorMap} attribute
   */
  @Override
  protected ImmutableMap<Value<?>, ValidationError> validationErrorMap() {
    return validationErrorMap;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#unvalidated() unvalidated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unvalidated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withUnvalidated(ValueContainer value) {
    if (this.unvalidated == value) return this;
    ValueContainer newValue = Objects.requireNonNull(value, "unvalidated");
    return validate(new ImmutableContext(newValue, this.validatedValues, this.validationErrorMap));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#validatedValues() validatedValues} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validatedValues
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withValidatedValues(ValueContainer value) {
    if (this.validatedValues == value) return this;
    ValueContainer newValue = Objects.requireNonNull(value, "validatedValues");
    return validate(new ImmutableContext(this.unvalidated, newValue, this.validationErrorMap));
  }

  /**
   * Copy the current immutable object by replacing the {@link Context#validationErrorMap() validationErrorMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the validationErrorMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContext withValidationErrorMap(Map<? extends Value<?>, ? extends ValidationError> entries) {
    if (this.validationErrorMap == entries) return this;
    ImmutableMap<Value<?>, ValidationError> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableContext(this.unvalidated, this.validatedValues, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContext
        && equalTo(0, (ImmutableContext) another);
  }

  private boolean equalTo(int synthetic, ImmutableContext another) {
    return unvalidated.equals(another.unvalidated)
        && validatedValues.equals(another.validatedValues)
        && validationErrorMap.equals(another.validationErrorMap);
  }

  /**
   * Computes a hash code from attributes: {@code unvalidated}, {@code validatedValues}, {@code validationErrorMap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + unvalidated.hashCode();
    h += (h << 5) + validatedValues.hashCode();
    h += (h << 5) + validationErrorMap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Context} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Context")
        .omitNullValues()
        .add("unvalidated", unvalidated)
        .add("validatedValues", validatedValues)
        .add("validationErrorMap", validationErrorMap)
        .toString();
  }

  private static ImmutableContext validate(ImmutableContext instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Context} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Context instance
   */
  public static ImmutableContext copyOf(Context instance) {
    if (instance instanceof ImmutableContext) {
      return (ImmutableContext) instance;
    }
    return ImmutableContext.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContext ImmutableContext}.
   * <pre>
   * ImmutableContext.builder()
   *    .unvalidated(de.flapdoodle.formula.ValueContainer) // optional {@link Context#unvalidated() unvalidated}
   *    .validatedValues(de.flapdoodle.formula.ValueContainer) // optional {@link Context#validatedValues() validatedValues}
   *    .putValidationErrorMap|putAllValidationErrorMap(de.flapdoodle.formula.Value&amp;lt;?&amp;gt; =&gt; de.flapdoodle.formula.validation.ValidationError) // {@link Context#validationErrorMap() validationErrorMap} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableContext builder
   */
  public static ImmutableContext.Builder builder() {
    return new ImmutableContext.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContext ImmutableContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Context", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable ValueContainer unvalidated;
    private @Nullable ValueContainer validatedValues;
    private ImmutableMap.Builder<Value<?>, ValidationError> validationErrorMap = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Context} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Context instance) {
      Objects.requireNonNull(instance, "instance");
      unvalidated(instance.unvalidated());
      validatedValues(instance.validatedValues());
      putAllValidationErrorMap(instance.validationErrorMap());
      return this;
    }

    /**
     * Initializes the value for the {@link Context#unvalidated() unvalidated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Context#unvalidated() unvalidated}.</em>
     * @param unvalidated The value for unvalidated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder unvalidated(ValueContainer unvalidated) {
      this.unvalidated = Objects.requireNonNull(unvalidated, "unvalidated");
      return this;
    }

    /**
     * Initializes the value for the {@link Context#validatedValues() validatedValues} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Context#validatedValues() validatedValues}.</em>
     * @param validatedValues The value for validatedValues 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validatedValues(ValueContainer validatedValues) {
      this.validatedValues = Objects.requireNonNull(validatedValues, "validatedValues");
      return this;
    }

    /**
     * Put one entry to the {@link Context#validationErrorMap() validationErrorMap} map.
     * @param key The key in the validationErrorMap map
     * @param value The associated value in the validationErrorMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValidationErrorMap(Value<?> key, ValidationError value) {
      this.validationErrorMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Context#validationErrorMap() validationErrorMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValidationErrorMap(Map.Entry<? extends Value<?>, ? extends ValidationError> entry) {
      this.validationErrorMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Context#validationErrorMap() validationErrorMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the validationErrorMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validationErrorMap(Map<? extends Value<?>, ? extends ValidationError> entries) {
      this.validationErrorMap = ImmutableMap.builder();
      return putAllValidationErrorMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Context#validationErrorMap() validationErrorMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the validationErrorMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValidationErrorMap(Map<? extends Value<?>, ? extends ValidationError> entries) {
      this.validationErrorMap.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableContext ImmutableContext}.
     * @return An immutable instance of Context
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContext build() {
      return ImmutableContext.validate(new ImmutableContext(this));
    }
  }
}
