package de.flapdoodle.formula.explain;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuleVertex.ValueVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueVertex.of()}.
 */
@Generated(from = "RuleVertex.ValueVertex", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueVertex<T> extends RuleVertex.ValueVertex<T> {
  private final Value<T> value;

  private ImmutableValueVertex(Value<T> value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableValueVertex(ImmutableValueVertex<T> original, Value<T> value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Value<T> value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuleVertex.ValueVertex#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueVertex<T> withValue(Value<T> value) {
    if (this.value == value) return this;
    Value<T> newValue = Objects.requireNonNull(value, "value");
    return new ImmutableValueVertex<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueVertex<?>
        && equalTo(0, (ImmutableValueVertex<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueVertex<?> another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueVertex")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValueVertex} instance.
 * @param <T> generic parameter T
   * @param value The value for the {@code value} attribute
   * @return An immutable ValueVertex instance
   */
  public static <T> ImmutableValueVertex<T> of(Value<T> value) {
    return new ImmutableValueVertex<>(value);
  }

  /**
   * Creates an immutable copy of a {@link RuleVertex.ValueVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ValueVertex instance
   */
  public static <T> ImmutableValueVertex<T> copyOf(RuleVertex.ValueVertex<T> instance) {
    if (instance instanceof ImmutableValueVertex<?>) {
      return (ImmutableValueVertex<T>) instance;
    }
    return ImmutableValueVertex.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueVertex ImmutableValueVertex}.
   * <pre>
   * ImmutableValueVertex.&amp;lt;T&amp;gt;builder()
   *    .value(de.flapdoodle.formula.Value&amp;lt;T&amp;gt;) // required {@link RuleVertex.ValueVertex#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableValueVertex builder
   */
  public static <T> ImmutableValueVertex.Builder<T> builder() {
    return new ImmutableValueVertex.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableValueVertex ImmutableValueVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuleVertex.ValueVertex", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Value<T> value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(RuleVertex.ValueVertex<T> instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link RuleVertex.ValueVertex#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(Value<T> value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueVertex ImmutableValueVertex}.
     * @return An immutable instance of ValueVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueVertex<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueVertex<>(null, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ValueVertex, some of required attributes are not set " + attributes;
    }
  }
}
