package de.flapdoodle.formula.explain;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.validation.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuleVertex.ValidationVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValidationVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValidationVertex.of()}.
 */
@Generated(from = "RuleVertex.ValidationVertex", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValidationVertex<T>
    extends RuleVertex.ValidationVertex<T> {
  private final Validation<T> calculation;

  private ImmutableValidationVertex(Validation<T> calculation) {
    this.calculation = Objects.requireNonNull(calculation, "calculation");
  }

  private ImmutableValidationVertex(ImmutableValidationVertex<T> original, Validation<T> calculation) {
    this.calculation = calculation;
  }

  /**
   * @return The value of the {@code calculation} attribute
   */
  @Override
  public Validation<T> calculation() {
    return calculation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuleVertex.ValidationVertex#calculation() calculation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for calculation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValidationVertex<T> withCalculation(Validation<T> value) {
    if (this.calculation == value) return this;
    Validation<T> newValue = Objects.requireNonNull(value, "calculation");
    return new ImmutableValidationVertex<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValidationVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValidationVertex<?>
        && equalTo(0, (ImmutableValidationVertex<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableValidationVertex<?> another) {
    return calculation.equals(another.calculation);
  }

  /**
   * Computes a hash code from attributes: {@code calculation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + calculation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValidationVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValidationVertex")
        .omitNullValues()
        .add("calculation", calculation)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValidationVertex} instance.
 * @param <T> generic parameter T
   * @param calculation The value for the {@code calculation} attribute
   * @return An immutable ValidationVertex instance
   */
  public static <T> ImmutableValidationVertex<T> of(Validation<T> calculation) {
    return new ImmutableValidationVertex<>(calculation);
  }

  /**
   * Creates an immutable copy of a {@link RuleVertex.ValidationVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ValidationVertex instance
   */
  public static <T> ImmutableValidationVertex<T> copyOf(RuleVertex.ValidationVertex<T> instance) {
    if (instance instanceof ImmutableValidationVertex<?>) {
      return (ImmutableValidationVertex<T>) instance;
    }
    return ImmutableValidationVertex.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValidationVertex ImmutableValidationVertex}.
   * <pre>
   * ImmutableValidationVertex.&amp;lt;T&amp;gt;builder()
   *    .calculation(de.flapdoodle.formula.validation.Validation&amp;lt;T&amp;gt;) // required {@link RuleVertex.ValidationVertex#calculation() calculation}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableValidationVertex builder
   */
  public static <T> ImmutableValidationVertex.Builder<T> builder() {
    return new ImmutableValidationVertex.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableValidationVertex ImmutableValidationVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuleVertex.ValidationVertex", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_CALCULATION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Validation<T> calculation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValidationVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(RuleVertex.ValidationVertex<T> instance) {
      Objects.requireNonNull(instance, "instance");
      calculation(instance.calculation());
      return this;
    }

    /**
     * Initializes the value for the {@link RuleVertex.ValidationVertex#calculation() calculation} attribute.
     * @param calculation The value for calculation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> calculation(Validation<T> calculation) {
      this.calculation = Objects.requireNonNull(calculation, "calculation");
      initBits &= ~INIT_BIT_CALCULATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValidationVertex ImmutableValidationVertex}.
     * @return An immutable instance of ValidationVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValidationVertex<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValidationVertex<>(null, calculation);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CALCULATION) != 0) attributes.add("calculation");
      return "Cannot build ValidationVertex, some of required attributes are not set " + attributes;
    }
  }
}
