package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.Merge3}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMerge3.of()}.
 */
@Generated(from = "Calculations.Merge3", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableMerge3<A, B, C, X>
    extends Calculations.Merge3<A, B, C, X> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final ValueSource<C> c;
  private final Calculations.F3<A, B, C, X> transformation;

  private ImmutableMerge3(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      Calculations.F3<A, B, C, X> transformation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.transformation = Objects.requireNonNull(transformation, "transformation");
  }

  private ImmutableMerge3(
      ImmutableMerge3<A, B, C, X> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      Calculations.F3<A, B, C, X> transformation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.c = c;
    this.transformation = transformation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected ValueSource<C> c() {
    return c;
  }

  /**
   * @return The value of the {@code transformation} attribute
   */
  @Override
  protected Calculations.F3<A, B, C, X> transformation() {
    return transformation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge3#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<A, B, C, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge3<>(this, newValue, this.a, this.b, this.c, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge3#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<A, B, C, X> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableMerge3<>(this, this.destination, newValue, this.b, this.c, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge3#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<A, B, C, X> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableMerge3<>(this, this.destination, this.a, newValue, this.c, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge3#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<A, B, C, X> withC(ValueSource<C> value) {
    if (this.c == value) return this;
    ValueSource<C> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableMerge3<>(this, this.destination, this.a, this.b, newValue, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge3#transformation() transformation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transformation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<A, B, C, X> withTransformation(Calculations.F3<A, B, C, X> value) {
    if (this.transformation == value) return this;
    Calculations.F3<A, B, C, X> newValue = Objects.requireNonNull(value, "transformation");
    return new ImmutableMerge3<>(this, this.destination, this.a, this.b, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge3<?, ?, ?, ?>
        && equalTo(0, (ImmutableMerge3<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMerge3<?, ?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && transformation.equals(another.transformation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code c}, {@code transformation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + transformation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Merge3")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("transformation", transformation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Merge3} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param transformation The value for the {@code transformation} attribute
   * @return An immutable Merge3 instance
   */
  public static <A, B, C, X> ImmutableMerge3<A, B, C, X> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, Calculations.F3<A, B, C, X> transformation) {
    return new ImmutableMerge3<>(destination, a, b, c, transformation);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.Merge3} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Merge3 instance
   */
  public static <A, B, C, X> ImmutableMerge3<A, B, C, X> copyOf(Calculations.Merge3<A, B, C, X> instance) {
    if (instance instanceof ImmutableMerge3<?, ?, ?, ?>) {
      return (ImmutableMerge3<A, B, C, X>) instance;
    }
    return ImmutableMerge3.<A, B, C, X>of(instance.destination(), instance.a(), instance.b(), instance.c(), instance.transformation());
  }
}
