package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.Merge2}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMerge2.of()}.
 */
@Generated(from = "Calculations.Merge2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableMerge2<A, B, X>
    extends Calculations.Merge2<A, B, X> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final Calculations.F2<A, B, X> transformation;

  private ImmutableMerge2(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      Calculations.F2<A, B, X> transformation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.transformation = Objects.requireNonNull(transformation, "transformation");
  }

  private ImmutableMerge2(
      ImmutableMerge2<A, B, X> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      Calculations.F2<A, B, X> transformation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.transformation = transformation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code transformation} attribute
   */
  @Override
  protected Calculations.F2<A, B, X> transformation() {
    return transformation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge2#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<A, B, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge2<>(this, newValue, this.a, this.b, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge2#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<A, B, X> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableMerge2<>(this, this.destination, newValue, this.b, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge2#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<A, B, X> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableMerge2<>(this, this.destination, this.a, newValue, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Merge2#transformation() transformation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transformation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<A, B, X> withTransformation(Calculations.F2<A, B, X> value) {
    if (this.transformation == value) return this;
    Calculations.F2<A, B, X> newValue = Objects.requireNonNull(value, "transformation");
    return new ImmutableMerge2<>(this, this.destination, this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge2<?, ?, ?>
        && equalTo(0, (ImmutableMerge2<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMerge2<?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && transformation.equals(another.transformation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code transformation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + transformation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Merge2")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("transformation", transformation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Merge2} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param transformation The value for the {@code transformation} attribute
   * @return An immutable Merge2 instance
   */
  public static <A, B, X> ImmutableMerge2<A, B, X> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, Calculations.F2<A, B, X> transformation) {
    return new ImmutableMerge2<>(destination, a, b, transformation);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.Merge2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Merge2 instance
   */
  public static <A, B, X> ImmutableMerge2<A, B, X> copyOf(Calculations.Merge2<A, B, X> instance) {
    if (instance instanceof ImmutableMerge2<?, ?, ?>) {
      return (ImmutableMerge2<A, B, X>) instance;
    }
    return ImmutableMerge2.<A, B, X>of(instance.destination(), instance.a(), instance.b(), instance.transformation());
  }
}
