package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.F2Explained}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableF2Explained.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableF2Explained.of()}.
 */
@Generated(from = "Calculations.F2Explained", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableF2Explained<A, B, R>
    extends Calculations.F2Explained<A, B, R> {
  private final Calculations.F2<A, B, R> delegate;
  private final String label;

  private ImmutableF2Explained(Calculations.F2<A, B, R> delegate, String label) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.label = Objects.requireNonNull(label, "label");
  }

  private ImmutableF2Explained(
      ImmutableF2Explained<A, B, R> original,
      Calculations.F2<A, B, R> delegate,
      String label) {
    this.delegate = delegate;
    this.label = label;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected Calculations.F2<A, B, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  protected String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.F2Explained#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF2Explained<A, B, R> withDelegate(Calculations.F2<A, B, R> value) {
    if (this.delegate == value) return this;
    Calculations.F2<A, B, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableF2Explained<>(this, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.F2Explained#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF2Explained<A, B, R> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableF2Explained<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableF2Explained} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableF2Explained<?, ?, ?>
        && equalTo(0, (ImmutableF2Explained<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableF2Explained<?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code F2Explained} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("F2Explained")
        .omitNullValues()
        .add("delegate", delegate)
        .add("label", label)
        .toString();
  }

  /**
   * Construct a new immutable {@code F2Explained} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param label The value for the {@code label} attribute
   * @return An immutable F2Explained instance
   */
  public static <A, B, R> ImmutableF2Explained<A, B, R> of(Calculations.F2<A, B, R> delegate, String label) {
    return new ImmutableF2Explained<>(delegate, label);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.F2Explained} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable F2Explained instance
   */
  public static <A, B, R> ImmutableF2Explained<A, B, R> copyOf(Calculations.F2Explained<A, B, R> instance) {
    if (instance instanceof ImmutableF2Explained<?, ?, ?>) {
      return (ImmutableF2Explained<A, B, R>) instance;
    }
    return ImmutableF2Explained.<A, B, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableF2Explained ImmutableF2Explained}.
   * <pre>
   * ImmutableF2Explained.&amp;lt;A, B, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.Calculations.F2&amp;lt;A, B, R&amp;gt;) // required {@link Calculations.F2Explained#delegate() delegate}
   *    .label(String) // required {@link Calculations.F2Explained#label() label}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <R> generic parameter R
   * @return A new ImmutableF2Explained builder
   */
  public static <A, B, R> ImmutableF2Explained.Builder<A, B, R> builder() {
    return new ImmutableF2Explained.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableF2Explained ImmutableF2Explained}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Calculations.F2Explained", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Calculations.F2<A, B, R> delegate;
    private @Nullable String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code F2Explained} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> from(Calculations.F2Explained<A, B, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link Calculations.F2Explained#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> delegate(Calculations.F2<A, B, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Calculations.F2Explained#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableF2Explained ImmutableF2Explained}.
     * @return An immutable instance of F2Explained
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableF2Explained<A, B, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableF2Explained<>(null, delegate, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build F2Explained, some of required attributes are not set " + attributes;
    }
  }
}
