package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.F1Explained}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableF1Explained.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableF1Explained.of()}.
 */
@Generated(from = "Calculations.F1Explained", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableF1Explained<A, R>
    extends Calculations.F1Explained<A, R> {
  private final Calculations.F1<A, R> delegate;
  private final String label;

  private ImmutableF1Explained(Calculations.F1<A, R> delegate, String label) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.label = Objects.requireNonNull(label, "label");
  }

  private ImmutableF1Explained(
      ImmutableF1Explained<A, R> original,
      Calculations.F1<A, R> delegate,
      String label) {
    this.delegate = delegate;
    this.label = label;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected Calculations.F1<A, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  protected String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.F1Explained#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF1Explained<A, R> withDelegate(Calculations.F1<A, R> value) {
    if (this.delegate == value) return this;
    Calculations.F1<A, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableF1Explained<>(this, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.F1Explained#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF1Explained<A, R> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableF1Explained<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableF1Explained} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableF1Explained<?, ?>
        && equalTo(0, (ImmutableF1Explained<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableF1Explained<?, ?> another) {
    return delegate.equals(another.delegate)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code F1Explained} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("F1Explained")
        .omitNullValues()
        .add("delegate", delegate)
        .add("label", label)
        .toString();
  }

  /**
   * Construct a new immutable {@code F1Explained} instance.
 * @param <A> generic parameter A
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param label The value for the {@code label} attribute
   * @return An immutable F1Explained instance
   */
  public static <A, R> ImmutableF1Explained<A, R> of(Calculations.F1<A, R> delegate, String label) {
    return new ImmutableF1Explained<>(delegate, label);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.F1Explained} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable F1Explained instance
   */
  public static <A, R> ImmutableF1Explained<A, R> copyOf(Calculations.F1Explained<A, R> instance) {
    if (instance instanceof ImmutableF1Explained<?, ?>) {
      return (ImmutableF1Explained<A, R>) instance;
    }
    return ImmutableF1Explained.<A, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableF1Explained ImmutableF1Explained}.
   * <pre>
   * ImmutableF1Explained.&amp;lt;A, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.Calculations.F1&amp;lt;A, R&amp;gt;) // required {@link Calculations.F1Explained#delegate() delegate}
   *    .label(String) // required {@link Calculations.F1Explained#label() label}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @return A new ImmutableF1Explained builder
   */
  public static <A, R> ImmutableF1Explained.Builder<A, R> builder() {
    return new ImmutableF1Explained.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableF1Explained ImmutableF1Explained}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Calculations.F1Explained", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Calculations.F1<A, R> delegate;
    private @Nullable String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code F1Explained} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> from(Calculations.F1Explained<A, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link Calculations.F1Explained#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> delegate(Calculations.F1<A, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Calculations.F1Explained#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableF1Explained ImmutableF1Explained}.
     * @return An immutable instance of F1Explained
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableF1Explained<A, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableF1Explained<>(null, delegate, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build F1Explained, some of required attributes are not set " + attributes;
    }
  }
}
