package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.Direct}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDirect.of()}.
 */
@Generated(from = "Calculations.Direct", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDirect<A, X> extends Calculations.Direct<A, X> {
  private final Value<X> destination;
  private final ValueSource<A> source;
  private final Calculations.F1<A, X> transformation;

  private ImmutableDirect(
      Value<X> destination,
      ValueSource<A> source,
      Calculations.F1<A, X> transformation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.source = Objects.requireNonNull(source, "source");
    this.transformation = Objects.requireNonNull(transformation, "transformation");
  }

  private ImmutableDirect(
      ImmutableDirect<A, X> original,
      Value<X> destination,
      ValueSource<A> source,
      Calculations.F1<A, X> transformation) {
    this.destination = destination;
    this.source = source;
    this.transformation = transformation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  protected ValueSource<A> source() {
    return source;
  }

  /**
   * @return The value of the {@code transformation} attribute
   */
  @Override
  protected Calculations.F1<A, X> transformation() {
    return transformation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Direct#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDirect<A, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableDirect<>(this, newValue, this.source, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Direct#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDirect<A, X> withSource(ValueSource<A> value) {
    if (this.source == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableDirect<>(this, this.destination, newValue, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Direct#transformation() transformation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transformation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDirect<A, X> withTransformation(Calculations.F1<A, X> value) {
    if (this.transformation == value) return this;
    Calculations.F1<A, X> newValue = Objects.requireNonNull(value, "transformation");
    return new ImmutableDirect<>(this, this.destination, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDirect} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDirect<?, ?>
        && equalTo(0, (ImmutableDirect<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableDirect<?, ?> another) {
    return destination.equals(another.destination)
        && source.equals(another.source)
        && transformation.equals(another.transformation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code source}, {@code transformation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + transformation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Direct} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Direct")
        .omitNullValues()
        .add("destination", destination)
        .add("source", source)
        .add("transformation", transformation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Direct} instance.
 * @param <A> generic parameter A
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param source The value for the {@code source} attribute
   * @param transformation The value for the {@code transformation} attribute
   * @return An immutable Direct instance
   */
  public static <A, X> ImmutableDirect<A, X> of(Value<X> destination, ValueSource<A> source, Calculations.F1<A, X> transformation) {
    return new ImmutableDirect<>(destination, source, transformation);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.Direct} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Direct instance
   */
  public static <A, X> ImmutableDirect<A, X> copyOf(Calculations.Direct<A, X> instance) {
    if (instance instanceof ImmutableDirect<?, ?>) {
      return (ImmutableDirect<A, X>) instance;
    }
    return ImmutableDirect.<A, X>of(instance.destination(), instance.source(), instance.transformation());
  }
}
