package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Calculations.Aggregated}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAggregated.of()}.
 */
@Generated(from = "Calculations.Aggregated", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAggregated<S, X>
    extends Calculations.Aggregated<S, X> {
  private final Value<X> destination;
  private final ImmutableList<ValueSource<S>> sourceList;
  private final Calculations.F1<List<S>, X> aggregation;

  private ImmutableAggregated(
      Value<X> destination,
      Iterable<? extends ValueSource<S>> sourceList,
      Calculations.F1<List<S>, X> aggregation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.sourceList = ImmutableList.copyOf(sourceList);
    this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
  }

  private ImmutableAggregated(
      ImmutableAggregated<S, X> original,
      Value<X> destination,
      ImmutableList<ValueSource<S>> sourceList,
      Calculations.F1<List<S>, X> aggregation) {
    this.destination = destination;
    this.sourceList = sourceList;
    this.aggregation = aggregation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code sourceList} attribute
   */
  @Override
  protected ImmutableList<ValueSource<S>> sourceList() {
    return sourceList;
  }

  /**
   * @return The value of the {@code aggregation} attribute
   */
  @Override
  protected Calculations.F1<List<S>, X> aggregation() {
    return aggregation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Aggregated#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregated<S, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableAggregated<>(this, newValue, this.sourceList, this.aggregation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Calculations.Aggregated#sourceList() sourceList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableAggregated<S, X> withSourceList(ValueSource<S>... elements) {
    ImmutableList<ValueSource<S>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAggregated<>(this, this.destination, newValue, this.aggregation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Calculations.Aggregated#sourceList() sourceList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sourceList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAggregated<S, X> withSourceList(Iterable<? extends ValueSource<S>> elements) {
    if (this.sourceList == elements) return this;
    ImmutableList<ValueSource<S>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAggregated<>(this, this.destination, newValue, this.aggregation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Calculations.Aggregated#aggregation() aggregation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aggregation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregated<S, X> withAggregation(Calculations.F1<List<S>, X> value) {
    if (this.aggregation == value) return this;
    Calculations.F1<List<S>, X> newValue = Objects.requireNonNull(value, "aggregation");
    return new ImmutableAggregated<>(this, this.destination, this.sourceList, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAggregated} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAggregated<?, ?>
        && equalTo(0, (ImmutableAggregated<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableAggregated<?, ?> another) {
    return destination.equals(another.destination)
        && sourceList.equals(another.sourceList)
        && aggregation.equals(another.aggregation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code sourceList}, {@code aggregation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + sourceList.hashCode();
    h += (h << 5) + aggregation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Aggregated} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Aggregated")
        .omitNullValues()
        .add("destination", destination)
        .add("sourceList", sourceList)
        .add("aggregation", aggregation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Aggregated} instance.
 * @param <S> generic parameter S
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param sourceList The value for the {@code sourceList} attribute
   * @param aggregation The value for the {@code aggregation} attribute
   * @return An immutable Aggregated instance
   */
  public static <S, X> ImmutableAggregated<S, X> of(Value<X> destination, List<ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
    return of(destination, (Iterable<? extends ValueSource<S>>) sourceList, aggregation);
  }

  /**
   * Construct a new immutable {@code Aggregated} instance.
 * @param <S> generic parameter S
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param sourceList The value for the {@code sourceList} attribute
   * @param aggregation The value for the {@code aggregation} attribute
   * @return An immutable Aggregated instance
   */
  public static <S, X> ImmutableAggregated<S, X> of(Value<X> destination, Iterable<? extends ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
    return new ImmutableAggregated<>(destination, sourceList, aggregation);
  }

  /**
   * Creates an immutable copy of a {@link Calculations.Aggregated} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Aggregated instance
   */
  public static <S, X> ImmutableAggregated<S, X> copyOf(Calculations.Aggregated<S, X> instance) {
    if (instance instanceof ImmutableAggregated<?, ?>) {
      return (ImmutableAggregated<S, X>) instance;
    }
    return ImmutableAggregated.<S, X>of(instance.destination(), instance.sourceList(), instance.aggregation());
  }
}
