/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values.properties;

import com.google.common.base.Preconditions;
import de.flapdoodle.formula.types.HasHumanReadableLabel;
import de.flapdoodle.formula.types.Id;
import de.flapdoodle.formula.values.domain.ReadOnlyValue;
import de.flapdoodle.formula.values.properties.ImmutableReadOnlyProperty;
import de.flapdoodle.formula.values.properties.IsReadable;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ReadOnlyProperty<O, T>
implements IsReadable<O, T>,
HasHumanReadableLabel {
    @Value.Parameter
    protected abstract Class<O> type();

    @Value.Parameter
    protected abstract String name();

    @Value.Parameter
    protected abstract Function<O, T> getter();

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.type().getSimpleName() + "." + this.name() + "}";
    }

    @Override
    public String asHumanReadable() {
        return this.type().getSimpleName() + "." + this.name() + "()";
    }

    @Override
    @Value.Auxiliary
    public T get(O instance) {
        Preconditions.checkArgument((boolean)this.type().isInstance(instance), (String)"instance type mismatch: %s != %s", this.type(), instance);
        return this.getter().apply(instance);
    }

    public ReadOnlyValue<O, T> withId(Id<O> id) {
        return ReadOnlyValue.of(id, this);
    }

    public static <O, T> ImmutableReadOnlyProperty<O, T> of(Class<O> type, String name, Function<O, T> getter) {
        return ImmutableReadOnlyProperty.of(type, name, getter);
    }
}

