/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values.properties;

import com.google.common.base.Preconditions;
import de.flapdoodle.formula.values.properties.ImmutableModifiableProperty;
import de.flapdoodle.formula.values.properties.IsReadable;
import de.flapdoodle.formula.values.properties.IsWritable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ModifiableProperty<O, T>
implements IsReadable<O, T>,
IsWritable<O, T> {
    @Value.Parameter
    protected abstract Class<O> type();

    @Value.Parameter
    protected abstract String name();

    @Value.Parameter
    protected abstract Function<O, T> getter();

    @Value.Parameter
    protected abstract BiConsumer<O, T> setter();

    @Override
    public T get(O instance) {
        Preconditions.checkArgument((boolean)this.type().isInstance(instance), (String)"instance type mismatch: %s != %s", this.type(), instance);
        return this.getter().apply(instance);
    }

    @Override
    public void set(O instance, T value) {
        Preconditions.checkArgument((boolean)this.type().isInstance(instance), (String)"instance type mismatch: %s != %s", this.type(), instance);
        this.setter().accept(instance, value);
    }

    public static <O, T> ImmutableModifiableProperty<O, T> of(Class<O> type, String name, Function<O, T> getter, BiConsumer<O, T> setter) {
        return ImmutableModifiableProperty.of(type, name, getter, setter);
    }
}

