/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values.properties;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.values.properties.ReadOnlyProperty;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReadOnlyProperty", generator="Immutables")
@Immutable
public final class ImmutableReadOnlyProperty<O, T>
extends ReadOnlyProperty<O, T> {
    private final Class<O> type;
    private final String name;
    private final Function<O, T> getter;

    private ImmutableReadOnlyProperty(Class<O> type, String name, Function<O, T> getter) {
        this.type = Objects.requireNonNull(type, "type");
        this.name = Objects.requireNonNull(name, "name");
        this.getter = Objects.requireNonNull(getter, "getter");
    }

    private ImmutableReadOnlyProperty(ImmutableReadOnlyProperty<O, T> original, Class<O> type, String name, Function<O, T> getter) {
        this.type = type;
        this.name = name;
        this.getter = getter;
    }

    @Override
    protected Class<O> type() {
        return this.type;
    }

    @Override
    protected String name() {
        return this.name;
    }

    @Override
    protected Function<O, T> getter() {
        return this.getter;
    }

    public final ImmutableReadOnlyProperty<O, T> withType(Class<O> value) {
        if (this.type == value) {
            return this;
        }
        Class<O> newValue = Objects.requireNonNull(value, "type");
        return new ImmutableReadOnlyProperty<O, T>(this, newValue, this.name, this.getter);
    }

    public final ImmutableReadOnlyProperty<O, T> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableReadOnlyProperty<O, T>(this, this.type, newValue, this.getter);
    }

    public final ImmutableReadOnlyProperty<O, T> withGetter(Function<O, T> value) {
        if (this.getter == value) {
            return this;
        }
        Function<O, T> newValue = Objects.requireNonNull(value, "getter");
        return new ImmutableReadOnlyProperty<O, T>(this, this.type, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadOnlyProperty && this.equalTo(0, (ImmutableReadOnlyProperty)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadOnlyProperty<?, ?> another) {
        return this.type.equals(another.type) && this.name.equals(another.name) && this.getter.equals(another.getter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.getter.hashCode();
        return h;
    }

    public static <O, T> ImmutableReadOnlyProperty<O, T> of(Class<O> type, String name, Function<O, T> getter) {
        return new ImmutableReadOnlyProperty<O, T>(type, name, getter);
    }

    public static <O, T> ImmutableReadOnlyProperty<O, T> copyOf(ReadOnlyProperty<O, T> instance) {
        if (instance instanceof ImmutableReadOnlyProperty) {
            return (ImmutableReadOnlyProperty)instance;
        }
        return ImmutableReadOnlyProperty.builder().from(instance).build();
    }

    public static <O, T> Builder<O, T> builder() {
        return new Builder();
    }

    @Generated(from="ReadOnlyProperty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<O, T> {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_GETTER = 4L;
        private long initBits = 7L;
        @Nullable
        private Class<O> type;
        @Nullable
        private String name;
        @Nullable
        private Function<O, T> getter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> from(ReadOnlyProperty<O, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.name(instance.name());
            this.getter(instance.getter());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> type(Class<O> type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> getter(Function<O, T> getter) {
            this.getter = Objects.requireNonNull(getter, "getter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReadOnlyProperty<O, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadOnlyProperty(null, this.type, this.name, this.getter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("getter");
            }
            return "Cannot build ReadOnlyProperty, some of required attributes are not set " + attributes;
        }
    }
}

