/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values.properties;

import com.google.common.base.Preconditions;
import de.flapdoodle.formula.types.HasHumanReadableLabel;
import de.flapdoodle.formula.types.Id;
import de.flapdoodle.formula.values.domain.CopyOnChangeValue;
import de.flapdoodle.formula.values.properties.ImmutableCopyOnChangeProperty;
import de.flapdoodle.formula.values.properties.IsChangeable;
import de.flapdoodle.formula.values.properties.IsReadable;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CopyOnChangeProperty<O, T>
implements IsReadable<O, T>,
IsChangeable<O, T>,
HasHumanReadableLabel {
    @Value.Parameter
    protected abstract Class<O> type();

    @Value.Parameter
    protected abstract String name();

    @Value.Parameter
    protected abstract Function<O, T> getter();

    @Value.Parameter
    protected abstract BiFunction<O, T, O> copyOnWrite();

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.type().getSimpleName() + "." + this.name() + "}";
    }

    @Override
    public String asHumanReadable() {
        return this.type().getSimpleName() + "." + this.name() + "#rw";
    }

    @Override
    @Value.Auxiliary
    public T get(O instance) {
        Preconditions.checkArgument((boolean)this.type().isInstance(instance), (String)"instance type mismatch: %s != %s", this.type(), instance);
        return this.getter().apply(instance);
    }

    @Override
    @Value.Auxiliary
    public O change(O instance, T value) {
        Preconditions.checkArgument((boolean)this.type().isInstance(instance), (String)"instance type mismatch: %s != %s", this.type(), instance);
        return this.copyOnWrite().apply(instance, value);
    }

    public CopyOnChangeValue<O, T> withId(Id<O> id) {
        return CopyOnChangeValue.of(id, this);
    }

    public static <O, T> ImmutableCopyOnChangeProperty<O, T> of(Class<O> type, String name, Function<O, T> getter, BiFunction<O, T, O> copyOnWrite) {
        return ImmutableCopyOnChangeProperty.of(type, name, getter, copyOnWrite);
    }
}

