/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.validation.ErrorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorMessage", generator="Immutables")
@Immutable
public final class ImmutableErrorMessage
implements ErrorMessage {
    private final String key;
    private final ImmutableList<Object> args;
    private final ImmutableSet<ValueSource<?>> invalidSources;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableErrorMessage(Builder builder) {
        this.key = builder.key;
        if (builder.argsIsSet()) {
            this.initShim.args((ImmutableList<Object>)builder.args.build());
        }
        if (builder.invalidSourcesIsSet()) {
            this.initShim.invalidSources(builder.invalidSources.build());
        }
        this.args = this.initShim.args();
        this.invalidSources = this.initShim.invalidSources();
        this.initShim = null;
    }

    private ImmutableErrorMessage(String key, ImmutableList<Object> args, ImmutableSet<ValueSource<?>> invalidSources) {
        this.key = key;
        this.args = args;
        this.invalidSources = invalidSources;
        this.initShim = null;
    }

    private List<Object> argsInitialize() {
        return ErrorMessage.super.args();
    }

    private Set<ValueSource<?>> invalidSourcesInitialize() {
        return ErrorMessage.super.invalidSources();
    }

    @Override
    public String key() {
        return this.key;
    }

    public ImmutableList<Object> args() {
        InitShim shim = this.initShim;
        return shim != null ? shim.args() : this.args;
    }

    public ImmutableSet<ValueSource<?>> invalidSources() {
        InitShim shim = this.initShim;
        return shim != null ? shim.invalidSources() : this.invalidSources;
    }

    public final ImmutableErrorMessage withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorMessage(newValue, this.args, this.invalidSources);
    }

    public final ImmutableErrorMessage withArgs(Object ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableErrorMessage(this.key, (ImmutableList<Object>)newValue, this.invalidSources);
    }

    public final ImmutableErrorMessage withArgs(Iterable<? extends Object> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableErrorMessage(this.key, (ImmutableList<Object>)newValue, this.invalidSources);
    }

    @SafeVarargs
    public final ImmutableErrorMessage withInvalidSources(ValueSource<?> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableErrorMessage(this.key, this.args, newValue);
    }

    public final ImmutableErrorMessage withInvalidSources(Iterable<? extends ValueSource<?>> elements) {
        if (this.invalidSources == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableErrorMessage(this.key, this.args, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorMessage && this.equalTo(0, (ImmutableErrorMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorMessage another) {
        return this.key.equals(another.key) && this.args.equals(another.args) && this.invalidSources.equals(another.invalidSources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.args.hashCode();
        h += (h << 5) + this.invalidSources.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorMessage").omitNullValues().add("key", (Object)this.key).add("args", this.args).add("invalidSources", this.invalidSources).toString();
    }

    public static ImmutableErrorMessage copyOf(ErrorMessage instance) {
        if (instance instanceof ImmutableErrorMessage) {
            return (ImmutableErrorMessage)instance;
        }
        return ImmutableErrorMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_ARGS = 1L;
        private static final long OPT_BIT_INVALID_SOURCES = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String key;
        private ImmutableList.Builder<Object> args = ImmutableList.builder();
        private ImmutableSet.Builder<ValueSource<?>> invalidSources = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.addAllArgs(instance.args());
            this.addAllInvalidSources(instance.invalidSources());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(Object element) {
            this.args.add(element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(Object ... elements) {
            this.args.add(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Iterable<? extends Object> elements) {
            this.args = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArgs(Iterable<? extends Object> elements) {
            this.args.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInvalidSources(ValueSource<?> element) {
            this.invalidSources.add(element);
            this.optBits |= 2L;
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addInvalidSources(ValueSource<?> ... elements) {
            this.invalidSources.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder invalidSources(Iterable<? extends ValueSource<?>> elements) {
            this.invalidSources = ImmutableSet.builder();
            return this.addAllInvalidSources(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInvalidSources(Iterable<? extends ValueSource<?>> elements) {
            this.invalidSources.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        public ImmutableErrorMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorMessage(this);
        }

        private boolean argsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean invalidSourcesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ErrorMessage", generator="Immutables")
    private final class InitShim {
        private byte argsBuildStage = 0;
        private ImmutableList<Object> args;
        private byte invalidSourcesBuildStage = 0;
        private ImmutableSet<ValueSource<?>> invalidSources;

        private InitShim() {
        }

        ImmutableList<Object> args() {
            if (this.argsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argsBuildStage == 0) {
                this.argsBuildStage = (byte)-1;
                this.args = ImmutableList.copyOf((Collection)ImmutableErrorMessage.this.argsInitialize());
                this.argsBuildStage = 1;
            }
            return this.args;
        }

        void args(ImmutableList<Object> args) {
            this.args = args;
            this.argsBuildStage = 1;
        }

        ImmutableSet<ValueSource<?>> invalidSources() {
            if (this.invalidSourcesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.invalidSourcesBuildStage == 0) {
                this.invalidSourcesBuildStage = (byte)-1;
                this.invalidSources = ImmutableSet.copyOf((Collection)ImmutableErrorMessage.this.invalidSourcesInitialize());
                this.invalidSourcesBuildStage = 1;
            }
            return this.invalidSources;
        }

        void invalidSources(ImmutableSet<ValueSource<?>> invalidSources) {
            this.invalidSources = invalidSources;
            this.invalidSourcesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.argsBuildStage == -1) {
                attributes.add("args");
            }
            if (this.invalidSourcesBuildStage == -1) {
                attributes.add("invalidSources");
            }
            return "Cannot build ErrorMessage, attribute initializers form cycle " + attributes;
        }
    }
}

