/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.types;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.types.Either;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Either.Left", generator="Immutables")
@Immutable
final class ImmutableLeft<L, R>
extends Either.Left<L, R> {
    @Nullable
    private final L left;

    private ImmutableLeft(@Nullable L left) {
        this.left = left;
    }

    @Override
    @Nullable
    public L left() {
        return this.left;
    }

    public final ImmutableLeft<L, R> withLeft(@Nullable L value) {
        if (this.left == value) {
            return this;
        }
        return new ImmutableLeft<L, R>(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLeft && this.equalTo(0, (ImmutableLeft)another);
    }

    private boolean equalTo(int synthetic, ImmutableLeft<?, ?> another) {
        return Objects.equals(this.left, another.left);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.left);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Left").omitNullValues().add("left", this.left).toString();
    }

    public static <L, R> ImmutableLeft<L, R> of(@Nullable L left) {
        return new ImmutableLeft<L, R>(left);
    }

    public static <L, R> ImmutableLeft<L, R> copyOf(Either.Left<L, R> instance) {
        if (instance instanceof ImmutableLeft) {
            return (ImmutableLeft)instance;
        }
        return ImmutableLeft.builder().from(instance).build();
    }

    public static <L, R> Builder<L, R> builder() {
        return new Builder();
    }

    @Generated(from="Either.Left", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<L, R> {
        @Nullable
        private L left;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<L, R> from(Either.Left<L, R> instance) {
            Objects.requireNonNull(instance, "instance");
            L leftValue = instance.left();
            if (leftValue != null) {
                this.left(leftValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<L, R> left(@Nullable L left) {
            this.left = left;
            return this;
        }

        public ImmutableLeft<L, R> build() {
            return new ImmutableLeft(this.left);
        }
    }
}

