/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.types;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.types.Id;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Id", generator="Immutables")
@Immutable
public final class ImmutableId<O>
extends Id<O> {
    private final Class<O> type;
    private final int count;

    private ImmutableId(Class<O> type, int count) {
        this.type = Objects.requireNonNull(type, "type");
        this.count = count;
    }

    private ImmutableId(ImmutableId<O> original, Class<O> type, int count) {
        this.type = type;
        this.count = count;
    }

    @Override
    protected Class<O> type() {
        return this.type;
    }

    @Override
    protected int count() {
        return this.count;
    }

    public final ImmutableId<O> withType(Class<O> value) {
        if (this.type == value) {
            return this;
        }
        Class<O> newValue = Objects.requireNonNull(value, "type");
        return new ImmutableId<O>(this, newValue, this.count);
    }

    public final ImmutableId<O> withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableId<O>(this, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableId && this.equalTo(0, (ImmutableId)another);
    }

    private boolean equalTo(int synthetic, ImmutableId<?> another) {
        return this.type.equals(another.type) && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.count;
        return h;
    }

    public static <O> ImmutableId<O> of(Class<O> type, int count) {
        return new ImmutableId<O>(type, count);
    }

    public static <O> ImmutableId<O> copyOf(Id<O> instance) {
        if (instance instanceof ImmutableId) {
            return (ImmutableId)instance;
        }
        return ImmutableId.builder().from(instance).build();
    }

    public static <O> Builder<O> builder() {
        return new Builder();
    }

    @Generated(from="Id", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<O> {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private Class<O> type;
        private int count;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<O> from(Id<O> instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.count(instance.count());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O> type(Class<O> type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O> count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableId<O> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableId(null, this.type, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build Id, some of required attributes are not set " + attributes;
        }
    }
}

