/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.types;

import de.flapdoodle.formula.types.HasHumanReadableLabel;
import de.flapdoodle.formula.types.ImmutableId;
import de.flapdoodle.formula.types.TypeCounter;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Id<O>
implements HasHumanReadableLabel {
    private static TypeCounter typeCounter = new TypeCounter();
    private static ThreadLocal<TypeCounter> localTypeCounter = new InheritableThreadLocal<TypeCounter>();

    @Value.Parameter
    protected abstract Class<O> type();

    @Value.Parameter
    protected abstract int count();

    @Value.Auxiliary
    public Optional<O> asInstance(Object value) {
        return this.type().isInstance(value) ? Optional.of(value) : Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.type().getSimpleName() + ", count=" + this.count() + "}";
    }

    @Override
    public String asHumanReadable() {
        return this.type().getSimpleName() + "#" + this.count();
    }

    public static <O> Id<O> idFor(Class<O> type) {
        TypeCounter currentCounter = localTypeCounter.get();
        return ImmutableId.of(type, (currentCounter != null ? currentCounter : typeCounter).count(type));
    }

    public static ClearTypeCounter with(TypeCounter typeCounter) {
        localTypeCounter.set(typeCounter);
        return () -> localTypeCounter.set(null);
    }

    public static interface ClearTypeCounter
    extends AutoCloseable {
        @Override
        public void close();
    }
}

