/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.calculate.CalculationMap;
import de.flapdoodle.formula.solver.GraphRenderer;
import de.flapdoodle.formula.validation.Validation;
import de.flapdoodle.formula.validation.ValidationMap;
import de.flapdoodle.graph.Graphs;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class ValueGraph {
    private final DefaultDirectedGraph<Value<?>, DefaultEdge> graph;
    private final CalculationMap calculationMap;
    private final ValidationMap validationMap;

    ValueGraph(DefaultDirectedGraph<Value<?>, DefaultEdge> graph, CalculationMap calculationMap, ValidationMap validationMap) {
        this.graph = graph;
        this.calculationMap = calculationMap;
        this.validationMap = validationMap;
        List loops = Graphs.rootsOf(graph).stream().flatMap(it -> it.loops().stream()).collect(Collectors.toList());
        if (!loops.isEmpty()) {
            String asDot = GraphRenderer.renderGraphAsDot(graph);
            throw new IllegalArgumentException(Strings.lenientFormat((String)"loops detected: %s\n-8<-------\n%s\n->8-------\n", (Object[])new Object[]{loops, asDot}));
        }
    }

    public <T> Calculation<T> calculation(Value<T> key) {
        return (Calculation)Preconditions.checkNotNull(this.calculationMap.get(key), (String)"calculation for %s not found", key);
    }

    public <T> Calculation<T> calculationOrNull(Value<T> key) {
        return this.calculationMap.get(key);
    }

    public <T> Validation<T> validation(Value<T> key) {
        return (Validation)Preconditions.checkNotNull(this.validationMap.get(key), (String)"validation for %s not found", key);
    }

    public <T> Validation<T> validationOrNull(Value<T> key) {
        return this.validationMap.get(key);
    }

    public Set<Value<?>> calculationDestinations() {
        return this.calculationMap.keys();
    }

    public DefaultDirectedGraph<Value<?>, DefaultEdge> graph() {
        return this.graph;
    }
}

