/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.flapdoodle.formula.Value;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ValueContainer {
    protected final Map<Value<?>, Object> values;
    protected final Set<Value<?>> nullValues;

    private ValueContainer(Map<Value<?>, Object> values, Set<Value<?>> nullValues) {
        this.values = values;
        this.nullValues = nullValues;
    }

    public <T> ValueContainer add(Value<T> id, T value) {
        Preconditions.checkArgument((!this.values.containsKey(id) ? 1 : 0) != 0, (String)"%s already set to %s", id, (Object)this.values.get(id));
        Preconditions.checkArgument((!this.nullValues.contains(id) ? 1 : 0) != 0, (String)"%s already set to null", id);
        return value != null ? new ValueContainer((Map<Value<?>, Object>)ImmutableMap.builder().putAll(this.values).put(id, value).build(), this.nullValues) : new ValueContainer(this.values, (Set<Value<?>>)ImmutableSet.builder().addAll(this.nullValues).add(id).build());
    }

    @Nullable
    public <T> T get(Value<T> id) {
        return (T)(!this.nullValues.contains(id) ? Preconditions.checkNotNull((Object)this.values.get(id), (String)"value %s not set", id) : null);
    }

    public Set<Value<?>> keys() {
        return Sets.union(this.values.keySet(), this.nullValues);
    }

    public String toString() {
        return "ValueContainer{values=" + this.values + ", nullValues=" + this.nullValues + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueContainer that = (ValueContainer)o;
        return this.values.equals(that.values) && this.nullValues.equals(that.nullValues);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.nullValues);
    }

    public static ValueContainer empty() {
        return new ValueContainer((Map<Value<?>, Object>)ImmutableMap.of(), (Set<Value<?>>)ImmutableSet.of());
    }
}

