/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.flapdoodle.formula.Unvalidated;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.solver.Context;
import de.flapdoodle.formula.solver.ValueGraph;
import de.flapdoodle.formula.types.Either;
import de.flapdoodle.formula.validation.ErrorMessage;
import de.flapdoodle.formula.validation.ValidatedValue;
import de.flapdoodle.formula.validation.Validation;
import de.flapdoodle.formula.validation.Validator;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.graph.VerticesAndEdges;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public abstract class Solver {
    private Solver() {
    }

    public static Result solve(ValueGraph valueGraph, ValueLookup lookup) {
        return Solver.asResult(Solver.solve(Context.empty(), valueGraph, lookup));
    }

    private static Result asResult(final Context context) {
        return new Result(){

            @Override
            public Set<Value<?>> validatedValues() {
                return context.validatedValues().keys();
            }

            @Override
            public Map<Value<?>, List<ErrorMessage>> validationErrors() {
                return context.errorMessages();
            }

            @Override
            @Nullable
            public <T> T get(Value<T> id) {
                return context.validatedValues().get(id);
            }
        };
    }

    static Context solve(Context context, ValueGraph valueGraph, ValueLookup lookup) {
        Collection roots = Graphs.rootsOf(valueGraph.graph());
        for (VerticesAndEdges it : roots) {
            Preconditions.checkArgument((boolean)it.loops().isEmpty(), (String)"loops found: %s", (Object)it.loops());
            for (Value node : it.vertices()) {
                context = Solver.process(lookup, valueGraph, node, context);
            }
        }
        return context;
    }

    private static Context process(ValueLookup lookup, ValueGraph valueGraph, Value<?> node, Context context) {
        if (node instanceof Unvalidated) {
            return Solver.processUnvalidated(lookup, (Unvalidated)node, context);
        }
        return Solver.processProcessed(lookup, valueGraph, node, context);
    }

    private static <T> Context processProcessed(ValueLookup lookup, ValueGraph valueGraph, Value<T> destination, Context context) {
        Calculation<T> calculation = valueGraph.calculationOrNull(destination);
        Validation<T> validation = valueGraph.validationOrNull(destination);
        Calculation.ValueLookup calculationLookup = Solver.calculationLookup(context, lookup);
        Validation.ValueLookup validationLookup = Solver.validationValueLookup(context, lookup);
        if (calculation != null || validation != null) {
            T calculated = calculation != null ? calculation.calculate(calculationLookup) : calculationLookup.get(destination);
            Either validated = validation != null ? Solver.validate(validationLookup, validation, calculated) : Either.left(calculated);
            return context.addValidated(destination, validated);
        }
        return context;
    }

    private static Calculation.ValueLookup calculationLookup(final Context context, final ValueLookup lookup) {
        return new Calculation.ValueLookup(){

            @Override
            @Nullable
            public <T> T get(Value<T> id) {
                return (T)Solver.value(context, lookup, id);
            }
        };
    }

    @Nullable
    private static <T> T value(Context context, ValueLookup lookup, Value<T> id) {
        return context.hasValidated(id) ? context.getValidated(id) : lookup.get(id);
    }

    private static Validation.ValueLookup validationValueLookup(final Context context, final ValueLookup lookup) {
        return new Validation.ValueLookup(){

            @Override
            public <T> ValidatedValue<T> get(ValueSource<T> id) {
                return id instanceof Unvalidated ? ValidatedValue.builder(id).value(Optional.ofNullable(context.getValue(id))).build() : ValidatedValue.builder(id).value(Optional.ofNullable(Solver.value(context, lookup, id))).invalidReferences(Solver.invalidReferences(context, id)).build();
            }
        };
    }

    private static <T> Either<T, List<ErrorMessage>> validate(Validation.ValueLookup valueLookup, Validation<T> validation, T calculated) {
        List<ErrorMessage> errorMessages = validation.validate(Solver.validator(), Optional.ofNullable(calculated), valueLookup);
        return errorMessages.isEmpty() ? Either.left(calculated) : Either.right(errorMessages);
    }

    private static <T> Iterable<? extends ValueSource<?>> invalidReferences(Context context, ValueSource<T> id) {
        return context.hasValidationErrors(id) ? ImmutableList.of(id) : ImmutableSet.of();
    }

    private static <T> Context processUnvalidated(ValueLookup lookup, Unvalidated<T> node, Context context) {
        return context.addValue(node, lookup.get(node.wrapped()));
    }

    private static Validator validator() {
        return new Validator(){};
    }

    public static interface Result {
        public Set<Value<?>> validatedValues();

        public Map<Value<?>, List<ErrorMessage>> validationErrors();

        @Nullable
        @Value.Auxiliary
        public <T> T get(Value<T> var1);
    }

    public static interface ValueLookup {
        @Nullable
        public <T> T get(Value<T> var1);
    }
}

