/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.Calculations;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Calculations.Aggregated", generator="Immutables")
@Immutable
final class ImmutableAggregated<S, X>
extends Calculations.Aggregated<S, X> {
    private final Value<X> destination;
    private final ImmutableList<ValueSource<S>> sourceList;
    private final Calculations.F1<List<S>, X> aggregation;

    private ImmutableAggregated(Value<X> destination, Iterable<? extends ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
        this.destination = Objects.requireNonNull(destination, "destination");
        this.sourceList = ImmutableList.copyOf(sourceList);
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
    }

    private ImmutableAggregated(ImmutableAggregated<S, X> original, Value<X> destination, ImmutableList<ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
        this.destination = destination;
        this.sourceList = sourceList;
        this.aggregation = aggregation;
    }

    @Override
    public Value<X> destination() {
        return this.destination;
    }

    @Override
    protected ImmutableList<ValueSource<S>> sourceList() {
        return this.sourceList;
    }

    @Override
    protected Calculations.F1<List<S>, X> aggregation() {
        return this.aggregation;
    }

    public final ImmutableAggregated<S, X> withDestination(Value<X> value) {
        if (this.destination == value) {
            return this;
        }
        Value<X> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableAggregated<S, X>(this, newValue, this.sourceList, this.aggregation);
    }

    @SafeVarargs
    public final ImmutableAggregated<S, X> withSourceList(ValueSource<S> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAggregated<S, X>(this, this.destination, newValue, this.aggregation);
    }

    public final ImmutableAggregated<S, X> withSourceList(Iterable<? extends ValueSource<S>> elements) {
        if (this.sourceList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAggregated<S, X>(this, this.destination, newValue, this.aggregation);
    }

    public final ImmutableAggregated<S, X> withAggregation(Calculations.F1<List<S>, X> value) {
        if (this.aggregation == value) {
            return this;
        }
        Calculations.F1<List<S>, X> newValue = Objects.requireNonNull(value, "aggregation");
        return new ImmutableAggregated<S, X>(this, this.destination, this.sourceList, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregated && this.equalTo(0, (ImmutableAggregated)another);
    }

    private boolean equalTo(int synthetic, ImmutableAggregated<?, ?> another) {
        return this.destination.equals(another.destination) && this.sourceList.equals(another.sourceList) && this.aggregation.equals(another.aggregation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.sourceList.hashCode();
        h += (h << 5) + this.aggregation.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Aggregated").omitNullValues().add("destination", this.destination).add("sourceList", this.sourceList).add("aggregation", this.aggregation).toString();
    }

    public static <S, X> ImmutableAggregated<S, X> of(Value<X> destination, List<ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
        return ImmutableAggregated.of(destination, sourceList, aggregation);
    }

    public static <S, X> ImmutableAggregated<S, X> of(Value<X> destination, Iterable<? extends ValueSource<S>> sourceList, Calculations.F1<List<S>, X> aggregation) {
        return new ImmutableAggregated<S, X>(destination, sourceList, aggregation);
    }

    public static <S, X> ImmutableAggregated<S, X> copyOf(Calculations.Aggregated<S, X> instance) {
        if (instance instanceof ImmutableAggregated) {
            return (ImmutableAggregated)instance;
        }
        return ImmutableAggregated.of(instance.destination(), instance.sourceList(), instance.aggregation());
    }
}

