/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula;

import com.google.common.collect.ImmutableList;
import de.flapdoodle.formula.ImmutableRules;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.calculate.CalculationMap;
import de.flapdoodle.formula.validation.Validation;
import de.flapdoodle.formula.validation.ValidationMap;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class Rules {
    @Value.Parameter
    public abstract CalculationMap calculations();

    @Value.Parameter
    public abstract ValidationMap validations();

    public ImmutableRules add(Calculation<?> calculation) {
        return ImmutableRules.copyOf(this).withCalculations(this.calculations().add(calculation));
    }

    public ImmutableRules add(Calculation<?> calculation, Calculation<?> ... other) {
        return this.addCalculations((List<Calculation<?>>)ImmutableList.builder().add(calculation).add((Object[])other).build());
    }

    public ImmutableRules addCalculations(List<Calculation<?>> calculations) {
        return ImmutableRules.copyOf(this).withCalculations(this.calculations().addAll(calculations));
    }

    public ImmutableRules add(Validation<?> validation) {
        return ImmutableRules.copyOf(this).withValidations(this.validations().add(validation));
    }

    public ImmutableRules add(Validation<?> validation, Validation<?> ... other) {
        return this.addValidations((List<Validation<?>>)ImmutableList.builder().add(validation).add((Object[])other).build());
    }

    public ImmutableRules addValidations(List<Validation<?>> validations) {
        return ImmutableRules.copyOf(this).withValidations(this.validations().addAll(validations));
    }

    public static ImmutableRules empty() {
        return ImmutableRules.of(CalculationMap.empty(), ValidationMap.empty());
    }
}

