/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg.ast;

import de.firemage.autograder.treeg.TreePrinter;
import de.firemage.autograder.treeg.ast.RegExNode;

public record Group(RegExNode root, String name, Type type, String flags) implements RegExNode
{
    @Override
    public String toRegEx() {
        String prefix = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.name != null) {
                    yield "?<" + this.name + ">";
                }
                yield "";
            }
            case 1 -> "?" + this.flags + ":";
            case 2 -> "?>";
        };
        return "(" + prefix + this.root.toRegEx() + ")";
    }

    @Override
    public void toTree(TreePrinter printer) {
        if (this.name != null) {
            printer.addLine("Named Group ('" + this.name + "')");
        } else {
            printer.addLine("Group");
        }
        printer.indent();
        this.root.toTree(printer);
        printer.unindent();
    }

    public static enum Type {
        CAPTURING,
        NON_CAPTURING,
        INDEPENDENT_NON_CAPTURING;

    }
}

