/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg;

import de.firemage.autograder.treeg.RegularExpression;
import de.firemage.autograder.treeg.ast.Alternative;
import de.firemage.autograder.treeg.ast.BoundaryMatcher;
import de.firemage.autograder.treeg.ast.CaptureGroupReference;
import de.firemage.autograder.treeg.ast.Chain;
import de.firemage.autograder.treeg.ast.CharacterClass;
import de.firemage.autograder.treeg.ast.CharacterClassEntry;
import de.firemage.autograder.treeg.ast.CharacterRange;
import de.firemage.autograder.treeg.ast.Group;
import de.firemage.autograder.treeg.ast.Lookaround;
import de.firemage.autograder.treeg.ast.PredefinedCharacterClass;
import de.firemage.autograder.treeg.ast.Quantifier;
import de.firemage.autograder.treeg.ast.RegExCharacter;
import de.firemage.autograder.treeg.ast.RegExNode;

public class Score {
    public static double scoreRegEx(RegularExpression regex) {
        return Score.scoreNode(regex.root());
    }

    private static double scoreNode(RegExNode node) {
        if (node instanceof RegExCharacter) {
            RegExCharacter c = (RegExCharacter)node;
            return Score.scoreCharacter(c);
        }
        if (node instanceof Alternative) {
            Alternative a = (Alternative)node;
            return Score.scoreAlternative(a);
        }
        if (node instanceof BoundaryMatcher) {
            BoundaryMatcher b = (BoundaryMatcher)node;
            return Score.scoreBoundaryMatcher(b);
        }
        if (node instanceof CaptureGroupReference) {
            CaptureGroupReference c = (CaptureGroupReference)node;
            return Score.scoreCaptureGroupReference(c);
        }
        if (node instanceof Chain) {
            Chain c = (Chain)node;
            return Score.scoreChain(c);
        }
        if (node instanceof CharacterClass) {
            CharacterClass c = (CharacterClass)node;
            return Score.scoreCharacterClass(c);
        }
        if (node instanceof Group) {
            Group g = (Group)node;
            return Score.scoreGroup(g);
        }
        if (node instanceof Lookaround) {
            Lookaround l = (Lookaround)node;
            return Score.scoreLookaround(l);
        }
        if (node instanceof PredefinedCharacterClass) {
            PredefinedCharacterClass p = (PredefinedCharacterClass)node;
            return Score.scorePredefinedCharacterClass(p);
        }
        if (node instanceof Quantifier) {
            Quantifier q = (Quantifier)node;
            return Score.scoreQuantifier(q);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static double scoreCharacter(RegExCharacter character) {
        if (character.escaped()) {
            return 0.5;
        }
        return 0.1;
    }

    private static double scoreAlternative(Alternative alternative) {
        return Math.exp((double)alternative.alternatives().size() / 5.0) * alternative.alternatives().stream().mapToDouble(Score::scoreNode).sum();
    }

    private static double scoreBoundaryMatcher(BoundaryMatcher matcher) {
        return 1.0;
    }

    private static double scoreCaptureGroupReference(CaptureGroupReference ref) {
        return 5.0;
    }

    private static double scoreChain(Chain chain) {
        return chain.children().stream().mapToDouble(Score::scoreNode).sum();
    }

    private static double scoreCharacterClass(CharacterClass c) {
        return (c.negated() ? 2.0 : 1.0) * c.ranges().stream().mapToDouble(Score::scoreCharacterClassEntry).sum();
    }

    private static double scoreCharacterClassEntry(CharacterClassEntry entry) {
        if (entry instanceof RegExCharacter) {
            RegExCharacter c = (RegExCharacter)entry;
            return Score.scoreCharacter(c);
        }
        if (entry instanceof CharacterRange) {
            CharacterRange r = (CharacterRange)entry;
            return Score.scoreCharacterRange(r);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static double scoreCharacterRange(CharacterRange range) {
        return 5.0;
    }

    private static double scoreGroup(Group group) {
        double multiplier;
        switch (group.type()) {
            default: {
                throw new MatchException(null, null);
            }
            case CAPTURING: {
                double d = 1.0;
                break;
            }
            case NON_CAPTURING: {
                double d = 2.0;
                break;
            }
            case INDEPENDENT_NON_CAPTURING: {
                double d = multiplier = 5.0;
            }
        }
        if (group.name() != null) {
            multiplier += 2.0;
        }
        if (group.flags() != null) {
            multiplier += Math.exp(group.flags().length());
        }
        return multiplier * Score.scoreNode(group.root());
    }

    private static double scoreLookaround(Lookaround lookaround) {
        return 10.0 * Score.scoreNode(lookaround.child());
    }

    private static double scorePredefinedCharacterClass(PredefinedCharacterClass c) {
        return switch (c.type()) {
            default -> throw new MatchException(null, null);
            case PredefinedCharacterClass.Type.ANY, PredefinedCharacterClass.Type.DIGIT, PredefinedCharacterClass.Type.WORD -> 0.5;
            case PredefinedCharacterClass.Type.NON_DIGIT, PredefinedCharacterClass.Type.WHITESPACE, PredefinedCharacterClass.Type.NON_WORD -> 2.0;
            case PredefinedCharacterClass.Type.HORIZONTAL_WHITESPACE, PredefinedCharacterClass.Type.NON_HORIZONTAL_WHITESPACE, PredefinedCharacterClass.Type.NON_WHITESPACE, PredefinedCharacterClass.Type.VERTICAL_WHITESPACE, PredefinedCharacterClass.Type.NON_VERTICAL_WHITESPACE -> 5.0;
        };
    }

    private static double scoreQuantifier(Quantifier quantifier) {
        return (switch (quantifier.type()) {
            default -> throw new MatchException(null, null);
            case Quantifier.Type.AT_MOST_ONCE, Quantifier.Type.ANY, Quantifier.Type.AT_LEAST_ONCE -> 1.5;
            case Quantifier.Type.TIMES, Quantifier.Type.OPEN_RANGE, Quantifier.Type.RANGE -> 2.0;
        }) * Score.scoreNode(quantifier.child());
    }
}

