/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg.ast;

import de.firemage.autograder.treeg.TreePrinter;
import de.firemage.autograder.treeg.ast.RegExNode;

public record Quantifier(RegExNode child, Type type, int min, int max) implements RegExNode
{
    @Override
    public String toRegEx() {
        String string = this.child.toRegEx();
        return string + (String)(switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.AT_MOST_ONCE -> "?";
            case Type.ANY -> "*";
            case Type.AT_LEAST_ONCE -> "+";
            case Type.TIMES -> "{" + this.min + "}";
            case Type.OPEN_RANGE -> "{" + this.min + ",}";
            case Type.RANGE -> "{" + this.min + "," + this.max + "}";
        });
    }

    @Override
    public void toTree(TreePrinter printer) {
        printer.addLine(this.type + " [" + this.min + ", " + this.max + "]");
        printer.indent();
        this.child.toTree(printer);
        printer.unindent();
    }

    public static enum Type {
        AT_MOST_ONCE,
        ANY,
        AT_LEAST_ONCE,
        TIMES,
        OPEN_RANGE,
        RANGE;

    }
}

